#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LidarOutputField */
namespace openplx::Sensors::Signals {
    class OPENPLX_Sensors_BUNDLE_EXPORT LidarOutputField : public openplx::Core::Object {
        protected:
            int64_t m_TimeStamp_F64 = 1;
            int64_t m_Position3D_F32 = 11;
            int64_t m_Distance_F32 = 12;
            int64_t m_RayPose3x4_F32 = 13;
            int64_t m_IsHit_I32 = 21;
            int64_t m_Intensity_F32 = 22;
            int64_t m_EntityId_I32 = 31;

        public:
            LidarOutputField();
            virtual ~LidarOutputField();
            int64_t TimeStamp_F64() const;
            int64_t Position3D_F32() const;
            int64_t Distance_F32() const;
            int64_t RayPose3x4_F32() const;
            int64_t IsHit_I32() const;
            int64_t Intensity_F32() const;
            int64_t EntityId_I32() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
