#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model IMUOutputFieldConstant */
namespace openplx::Sensors::Signals {
    class OPENPLX_Sensors_BUNDLE_EXPORT IMUOutputFieldConstant : public openplx::Core::Object {
        protected:
            int64_t m_X_F64 = 1;
            int64_t m_Y_F64 = 2;
            int64_t m_Z_F64 = 3;

        public:
            IMUOutputFieldConstant();
            virtual ~IMUOutputFieldConstant();
            int64_t X_F64() const;
            int64_t Y_F64() const;
            int64_t Z_F64() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
