#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Sensors/AccelerometerLogic.h>
#include <openplx/Physics/Signals/Marshalling.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AccelerometerOutput */
namespace openplx::Sensors::Signals {
    class OPENPLX_Sensors_BUNDLE_EXPORT AccelerometerOutput : public openplx::Physics::Signals::Output {
        protected:
            std::vector<int64_t> m_fields;
            std::weak_ptr<openplx::Sensors::AccelerometerLogic> m_source;

        public:
            AccelerometerOutput();
            virtual ~AccelerometerOutput();
            std::vector<int64_t> fields() const;
            std::shared_ptr<openplx::Sensors::AccelerometerLogic> source() const;
            static std::shared_ptr<openplx::Physics::Signals::Marshalling> marshalling_from_fields(std::vector<int64_t> fields);
            std::vector<double> readXValues(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<double> readYValues(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::vector<double> readZValues(const std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal>& signal) const;
            std::shared_ptr<openplx::Sensors::Signals::SensorOutputSignal> createSignal(const std::vector<double>& XValues, const std::vector<double>& YValues, const std::vector<double>& ZValues) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
