#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/GyroscopeSensingDistortion.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model GyroscopeSignalLinearAccelectionEffect */
namespace openplx::Sensors {
    /**
     *     A Gaussian noise error affecting the total magnitude of the measured gyroscope signal.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT GyroscopeSignalLinearAccelectionEffect : public openplx::Sensors::GyroscopeSensingDistortion {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_acceleration_effects;

        public:
            GyroscopeSignalLinearAccelectionEffect();
            virtual ~GyroscopeSignalLinearAccelectionEffect();
            std::shared_ptr<openplx::Math::Vec3> acceleration_effects() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
