#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Signals/InputSignal.h>
#include <openplx/Physics/Signals/RealValue.h>
#include <openplx/Physics/Signals/Input.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RobotInputSignal */
namespace openplx::Robotics::Signals {
    class OPENPLX_Robotics_BUNDLE_EXPORT RobotInputSignal : public openplx::Physics::Signals::InputSignal {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>> m_values;
            std::vector<bool> m_control_events;

        public:
            RobotInputSignal();
            virtual ~RobotInputSignal();
            std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>> values() const;
            std::vector<bool> control_events() const;
            static std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal> create(std::vector<double> values, std::vector<bool> control_events, std::shared_ptr<openplx::Physics::Signals::Input> target);
            static std::shared_ptr<openplx::Robotics::Signals::RobotInputSignal> from_values(std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>> values, std::vector<bool> control_events, std::shared_ptr<openplx::Physics::Signals::Input> target);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
