#pragma once

#include <memory>
#include <openplx/Document.h>
#include <openplx/Import.h>
#include <openplx/ErrorReporter.h>

namespace openplx {

    class Logger;

    class Plugin {
        public:
            virtual DocPtr parse(const std::string& key, ImportPtr import_node, ErrorReporter& error_reporter) = 0;
            virtual std::vector<std::string> extensions() = 0;
            virtual void setPrecision(int precision) = 0;
            virtual void setLogger(std::shared_ptr<Logger> logger) = 0;

            /**
             * Return true if the key passed to parse is the content of the imported file, if this returns
             * false the absolute path to the resource is passed as the key.
             */
            virtual bool keyShouldBeSource() = 0;
            virtual ~Plugin() = default;
    };
}
