#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Output */
namespace openplx::Physics3D::Signals::MateConnector {
    /**
     * Base model for MateConnector Outputs
     * Emits a ValueOutputSignal
     * You may also specify a MateConnector as the relative_to parameter to get the value relative to that mate connector
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT Output : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics3D::Interactions::MateConnector> m_source;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_relative_to;

        public:
            Output();
            virtual ~Output();
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> source() const;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> relative_to() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
