#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Position1DOutputTrait.h>
#include <openplx/Physics/Signals/Position1DInputTrait.h>
#include <openplx/Physics/Signals/Force1DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultDistanceDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultDistanceFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultDistanceThoughness.h>
#include <openplx/Physics/Signals/Position1DOutput.h>
#include <openplx/Physics/Signals/Position1DInput.h>
#include <openplx/Physics/Signals/Force1DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Distance */
namespace openplx::Physics3D::Interactions {
    /**
     *     A distance mate constrains only one degree of freedom, which is the distance
     *     between two mate connectors. It will try to keep the distance between them
     *     to be target_distance, with the constraining force acting along a line between
     *     the mate connectors.
     *     If one of the bodies is free to move, SNAP will move it the initial_distance
     *     along the main_axis during the initialization.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT Distance : public openplx::Physics3D::Interactions::Mate, public openplx::Physics::Signals::Position1DOutputTrait, public openplx::Physics::Signals::Position1DInputTrait, public openplx::Physics::Signals::Force1DOutputTrait {
        protected:
            double m_initial_distance;
            double m_target_distance;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> m_distance_output;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> m_target_distance_output;
            std::shared_ptr<openplx::Physics::Signals::Position1DInput> m_target_distance_input;
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> m_force_output;

        public:
            Distance();
            virtual ~Distance();
            double initial_distance() const;
            double target_distance() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness> toughness() const;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> distance_output() const;
            std::shared_ptr<openplx::Physics::Signals::Position1DOutput> target_distance_output() const;
            std::shared_ptr<openplx::Physics::Signals::Position1DInput> target_distance_input() const;
            std::shared_ptr<openplx::Physics::Signals::Force1DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
