#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model InputOutputType */
namespace openplx::Physics::Signals {
    class OPENPLX_Physics_BUNDLE_EXPORT InputOutputType : public openplx::Core::Object {
        protected:
            int64_t m_Position1D = 1;
            int64_t m_Position3D = 2;
            int64_t m_RPY = 3;
            int64_t m_Angle = 4;
            int64_t m_Velocity1D = 5;
            int64_t m_Velocity3D = 6;
            int64_t m_AngularVelocity1D = 7;
            int64_t m_AngularVelocity3D = 8;
            int64_t m_Torque1D = 9;
            int64_t m_Torque3D = 10;
            int64_t m_Force1D = 11;
            int64_t m_Force3D = 12;
            int64_t m_Acceleration3D = 13;
            int64_t m_AngularAcceleration3D = 14;
            int64_t m_Boolean = 15;
            int64_t m_Percentage = 16;
            int64_t m_Composite = 17;
            int64_t m_Integer = 18;
            int64_t m_Duration = 19;
            int64_t m_TorqueRange = 20;
            int64_t m_ForceRange = 21;
            int64_t m_Rpm = 22;
            int64_t m_Ratio = 23;
            int64_t m_Mass = 24;

        public:
            InputOutputType();
            virtual ~InputOutputType();
            int64_t Position1D() const;
            int64_t Position3D() const;
            int64_t RPY() const;
            int64_t Angle() const;
            int64_t Velocity1D() const;
            int64_t Velocity3D() const;
            int64_t AngularVelocity1D() const;
            int64_t AngularVelocity3D() const;
            int64_t Torque1D() const;
            int64_t Torque3D() const;
            int64_t Force1D() const;
            int64_t Force3D() const;
            int64_t Acceleration3D() const;
            int64_t AngularAcceleration3D() const;
            int64_t Boolean() const;
            int64_t Percentage() const;
            int64_t Composite() const;
            int64_t Integer() const;
            int64_t Duration() const;
            int64_t TorqueRange() const;
            int64_t ForceRange() const;
            int64_t Rpm() const;
            int64_t Ratio() const;
            int64_t Mass() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
