#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Bodies/Body.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model KinematicLock */
namespace openplx::Physics {
    /**
     * Locks bodies together kinematically.
     *
     * All the bodies specified in the `bodies` array will be locked kinematically, i.e.
     * they will behave as a single rigid body, they will maintain the translational offset
     * from the initial positioning after the SNAP algorithm has run. Any existing constraints
     * between locked bodies will be disabled.
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT KinematicLock : public openplx::Core::Object {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>> m_bodies;

        public:
            KinematicLock();
            virtual ~KinematicLock();
            std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>> bodies() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
