#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Toughness/DefaultToughness.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ThresholdPlasticFracture */
namespace openplx::Physics::Interactions::Toughness {
    /**
     *     Models the plastic and fracture behaviour for an interaction under stress.
     *     The yield_point defines the limit stress for yielding,
     *     and the fracture_point defines the point when to break.
     *     Force for linear, torque for angular.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT ThresholdPlasticFracture : public openplx::Physics::Interactions::Toughness::DefaultToughness {
        protected:
            double m_yield_point;
            double m_fracture_point;

        public:
            ThresholdPlasticFracture();
            virtual ~ThresholdPlasticFracture();
            double yield_point() const;
            double fracture_point() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
