#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathBundleExport.h>
#include <openplx/Math/MathForward.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Vec3 */
namespace openplx::Math {
    /**
     * angle_between_vectors      - Expects two vectors in the same plane and a third vector orthogonal to that plane.
     *                              Returns the angle between the two first vectors in radians in the range -PI to PI.
     * normal                     - Returns a normalized version of the vector
     * get_orthogonal_unit_vector - Returns a vector orthogonal to the current vector, i.e. a possible normal to the current vector.
     *     */
    class OPENPLX_Math_BUNDLE_EXPORT Vec3 : public openplx::Core::Object {
        protected:
            double m_x;
            double m_y;
            double m_z;

        public:
            Vec3();
            virtual ~Vec3();
            double x() const;
            double y() const;
            double z() const;
            static std::shared_ptr<openplx::Math::Vec3> X_AXIS();
            static std::shared_ptr<openplx::Math::Vec3> Y_AXIS();
            static std::shared_ptr<openplx::Math::Vec3> Z_AXIS();
            static std::shared_ptr<openplx::Math::Vec3> from_xyz(double x, double y, double z);
            double length() const;
            std::shared_ptr<openplx::Math::Vec3> normal() const;
            double dot(std::shared_ptr<openplx::Math::Vec3> rhs) const;
            std::shared_ptr<openplx::Math::Vec3> cross(std::shared_ptr<openplx::Math::Vec3> rhs) const;
            std::shared_ptr<openplx::Math::Vec3> get_orthogonal_unit_vector() const;
            static double angle_between_vectors(std::shared_ptr<openplx::Math::Vec3> vector1, std::shared_ptr<openplx::Math::Vec3> vector2, std::shared_ptr<openplx::Math::Vec3> rot_vector);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
