#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Simulation/CollisionGroup.h>
#include <openplx/Simulation/DisableCollisionPair.h>
#include <openplx/MachineModeling/Bearings/Pair.h>
/* Generated code for model Bearings */
namespace openplx::MachineModeling::Connections::Pivot::Traits {
    /**
     *     A trait for upgrading a Hinge connection to one with bearings.
     *     Independent of if there is an axle in the connection or not.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Bearings {
        public:
            Bearings();
            virtual ~Bearings();
            virtual std::shared_ptr<openplx::Simulation::CollisionGroup> bearing_collision_group() const = 0;
            virtual std::shared_ptr<openplx::Simulation::DisableCollisionPair> disable_bearings() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Bearings::Pair> from_bearings() const = 0;
            virtual std::shared_ptr<openplx::MachineModeling::Bearings::Pair> to_bearings() const = 0;
    };
}
