#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Connections/Pivot/AxleBearings.h>
#include <openplx/Physics3D/Interactions/LinearSpring.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LockedAxleBearings */
namespace openplx::MachineModeling::Connections::Pivot {
    /**
     *     Adds one lock from each connected component to the axle,
     *     so that it does not slide away.
     *     By default it chooses the left mate on the from side
     *     and the right mate on the to side.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT LockedAxleBearings : public openplx::MachineModeling::Connections::Pivot::AxleBearings {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring> m_from_lock;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring> m_to_lock;

        public:
            LockedAxleBearings();
            virtual ~LockedAxleBearings();
            std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring> from_lock() const;
            std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring> to_lock() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
