#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Visuals/Geometries/Cylinder.h>
/* Generated code for model CylinderVisual */
namespace openplx::MachineModeling::Actuators::Linear::Traits {
    /**
     *     Trait for adding a cylinder visual to the barrel or rod of the linear cylinder actuator.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT CylinderVisual {
        public:
            CylinderVisual();
            virtual ~CylinderVisual();
            virtual std::shared_ptr<openplx::Visuals::Geometries::Cylinder> visual() const = 0;
    };
}
