#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Actuators/Linear/Connections/Cylinder.h>
#include <openplx/MachineModeling/Actuators/Linear/CylinderBearings.h>
#include <openplx/MachineModeling/Components/Primitive/Axle/RigidCylindrical.h>
#include <openplx/MachineModeling/Connections/Pivot/LockedAxleBearings.h>
#include <openplx/MachineModeling/Bearings/Pair.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CylinderAxleBearings */
namespace openplx::MachineModeling::Actuators::Linear::Connections {
    /**
     *     Use an Axle for the cylinder bearing connection.
     *     Prevent it to slide sideways relative the connected components.
     **/
    class OPENPLX_MachineModeling_BUNDLE_EXPORT CylinderAxleBearings : public openplx::MachineModeling::Actuators::Linear::Connections::Cylinder {
        protected:
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical> m_barrel_axle;
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical> m_rod_axle;
            std::weak_ptr<openplx::MachineModeling::Bearings::Pair> m_from_bearings;
            std::weak_ptr<openplx::MachineModeling::Bearings::Pair> m_to_bearings;

        public:
            CylinderAxleBearings();
            virtual ~CylinderAxleBearings();
            std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings> actuator() const;
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical> barrel_axle() const;
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical> rod_axle() const;
            std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings> barrel_connection() const;
            std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings> rod_connection() const;
            std::shared_ptr<openplx::MachineModeling::Bearings::Pair> from_bearings() const;
            std::shared_ptr<openplx::MachineModeling::Bearings::Pair> to_bearings() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
