#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model JohnDeere6068HF485 */
namespace openplx::DriveTrain::Engines {
    /**
     *         Used in John Deere forwarder. https://www.deere.com/en/forwarders/1210g-forwarder/#tag-compare
     *         Reference: https://www.deere.com/assets/pdfs/common/industries/engines-and-drivetrain/specsheets/6068hf485_aux.pdf
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT JohnDeere6068HF485 : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            JohnDeere6068HF485();
            virtual ~JohnDeere6068HF485();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
