%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Visuals/Visuals_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Visuals::Geometries::Box;
%nspace openplx::Visuals::Geometries::ConvexMesh;
%nspace openplx::Visuals::Geometries::Cylinder;
%nspace openplx::Visuals::Geometries::ExternalTriMeshGeometry;
%nspace openplx::Visuals::Geometries::Geometry;
%nspace openplx::Visuals::Geometries::Sphere;
%nspace openplx::Visuals::Geometries::TriMeshGeometry;
%nspace openplx::Visuals::Materials::Material;
%nspace openplx::Visuals::Materials::TextureMaterial;
%shared_ptr(openplx::Visuals::Geometries::Box);
%shared_ptr(openplx::Visuals::Geometries::ConvexMesh);
%shared_ptr(openplx::Visuals::Geometries::Cylinder);
%shared_ptr(openplx::Visuals::Geometries::ExternalTriMeshGeometry);
%shared_ptr(openplx::Visuals::Geometries::Geometry);
%shared_ptr(openplx::Visuals::Geometries::Sphere);
%shared_ptr(openplx::Visuals::Geometries::TriMeshGeometry);
%shared_ptr(openplx::Visuals::Materials::Material);
%shared_ptr(openplx::Visuals::Materials::TextureMaterial);
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::Box)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::ConvexMesh)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::Cylinder)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::ExternalTriMeshGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::Geometry)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::Sphere)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Geometries::TriMeshGeometry)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Materials::Material)
OPENPLX_FIX_DOWNCASTING(openplx::Visuals::Materials::TextureMaterial)
%include "openplx/Visuals/Geometries/Geometry.h"
%include "openplx/Visuals/Geometries/Box.h"
%include "openplx/Visuals/Geometries/TriMeshGeometry.h"
%include "openplx/Visuals/Geometries/ConvexMesh.h"
%include "openplx/Visuals/Geometries/Cylinder.h"
%include "openplx/Visuals/Geometries/ExternalTriMeshGeometry.h"
%include "openplx/Visuals/Geometries/Sphere.h"
%include "openplx/Visuals/Materials/Material.h"
%include "openplx/Visuals/Materials/TextureMaterial.h"
%ignore Visuals_register_factories;
%include <openplx/Visuals/Visuals_all.h>
%inline {
    void Visuals_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Visuals_register_factories(eval_ctx);
    }
}
%template(VisualsGeometriesBoxVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Box>>;
%template(VisualsGeometriesConvexMeshVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>>;
%template(VisualsGeometriesCylinderVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Cylinder>>;
%template(VisualsGeometriesExternalTriMeshGeometryVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>>;
%template(VisualsGeometriesGeometryVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Geometry>>;
%template(VisualsGeometriesSphereVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Sphere>>;
%template(VisualsGeometriesTriMeshGeometryVector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>>;
%template(VisualsMaterialsMaterialVector) std::vector<std::shared_ptr<openplx::Visuals::Materials::Material>>;
%template(VisualsMaterialsTextureMaterialVector) std::vector<std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesBox, openplx::Visuals::Geometries::Box)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesConvexMesh, openplx::Visuals::Geometries::ConvexMesh)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesCylinder, openplx::Visuals::Geometries::Cylinder)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesExternalTriMeshGeometry, openplx::Visuals::Geometries::ExternalTriMeshGeometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesGeometry, openplx::Visuals::Geometries::Geometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesSphere, openplx::Visuals::Geometries::Sphere)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsGeometriesTriMeshGeometry, openplx::Visuals::Geometries::TriMeshGeometry)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsMaterialsMaterial, openplx::Visuals::Materials::Material)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVisualsMaterialsTextureMaterial, openplx::Visuals::Materials::TextureMaterial)
