%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Vehicles::Base;
%nspace openplx::Vehicles::Chassis::Articulated::Base;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualActuator;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualCylinder;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::ToFrames;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Interfaces::Frames;
%nspace openplx::Vehicles::Chassis::Articulated::Connections::Single::Base;
%nspace openplx::Vehicles::Chassis::Articulated::Hinge;
%nspace openplx::Vehicles::Chassis::Articulated::Interfaces::SingleJoint;
%nspace openplx::Vehicles::Chassis::Articulated::SingleJoint;
%nspace openplx::Vehicles::Chassis::Articulated::Universal;
%nspace openplx::Vehicles::Chassis::Rigid::Base;
%nspace openplx::Vehicles::FourWheel::Base;
%nspace openplx::Vehicles::FourWheel::FrontWheelDrive;
%nspace openplx::Vehicles::FourWheel::Properties::FrontSuspensionSteering;
%nspace openplx::Vehicles::FourWheel::Properties::RearSuspension;
%nspace openplx::Vehicles::Interfaces::UpForwardVectors;
%nspace openplx::Vehicles::Steering::Articulated::Base;
%nspace openplx::Vehicles::Steering::Articulated::DualActuator;
%nspace openplx::Vehicles::Steering::Articulated::DualCylinder;
%nspace openplx::Vehicles::Steering::Base;
%nspace openplx::Vehicles::Steering::Interfaces::Ackermann;
%nspace openplx::Vehicles::Steering::Interfaces::Base;
%nspace openplx::Vehicles::Steering::Interfaces::BellCrank;
%nspace openplx::Vehicles::Steering::Interfaces::RackAndPinion;
%nspace openplx::Vehicles::Steering::Kinematic::Ackermann;
%nspace openplx::Vehicles::Steering::Kinematic::Base;
%nspace openplx::Vehicles::Steering::Kinematic::BellCrank;
%nspace openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann;
%nspace openplx::Vehicles::Steering::Kinematic::Interactions::Base;
%nspace openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank;
%nspace openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion;
%nspace openplx::Vehicles::Steering::Kinematic::RackAndPinion;
%nspace openplx::Vehicles::Suspensions::Base;
%nspace openplx::Vehicles::Suspensions::Properties::Steering;
%nspace openplx::Vehicles::Suspensions::Properties::WheelAxisFromUpForward;
%nspace openplx::Vehicles::Suspensions::SingleMate::Base;
%nspace openplx::Vehicles::Suspensions::SingleMate::Interactions::Base;
%nspace openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper;
%nspace openplx::Vehicles::Suspensions::SingleMate::Interfaces::ChassisAttachmentConnectors;
%nspace openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper;
%nspace openplx::Vehicles::Tracks::Belt;
%nspace openplx::Vehicles::Tracks::BoxLinkDescription;
%nspace openplx::Vehicles::Tracks::BoxLinkVariation;
%nspace openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%nspace openplx::Vehicles::Tracks::CyclicVariation;
%nspace openplx::Vehicles::Tracks::CylindricalIdler;
%nspace openplx::Vehicles::Tracks::CylindricalRoadWheel;
%nspace openplx::Vehicles::Tracks::CylindricalRoller;
%nspace openplx::Vehicles::Tracks::CylindricalSprocket;
%nspace openplx::Vehicles::Tracks::DefaultLinkDescription;
%nspace openplx::Vehicles::Tracks::DefaultLinkVariation;
%nspace openplx::Vehicles::Tracks::DiscretePulseVariation;
%nspace openplx::Vehicles::Tracks::FixedLinkCountBelt;
%nspace openplx::Vehicles::Tracks::IntertialRoadWheel;
%nspace openplx::Vehicles::Tracks::RigidCylindricalIdler;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%nspace openplx::Vehicles::Tracks::RigidCylindricalRoller;
%nspace openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%nspace openplx::Vehicles::Tracks::RoadWheel;
%nspace openplx::Vehicles::Tracks::SinusoidalVariation;
%nspace openplx::Vehicles::Tracks::System;
%nspace openplx::Vehicles::Wheels::Actuator;
%nspace openplx::Vehicles::Wheels::Base;
%nspace openplx::Vehicles::Wheels::ElasticWheel;
%nspace openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation;
%nspace openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping;
%nspace openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility;
%nspace openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility;
%nspace openplx::Vehicles::Wheels::Rim;
%nspace openplx::Vehicles::Wheels::RimTrait;
%nspace openplx::Vehicles::Wheels::Tire;
%nspace openplx::Vehicles::Wheels::TireTrait;
%shared_ptr(openplx::Vehicles::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualActuator);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualCylinder);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::ToFrames);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Interfaces::Frames);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Single::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Hinge);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Interfaces::SingleJoint);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::SingleJoint);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Universal);
%shared_ptr(openplx::Vehicles::Chassis::Rigid::Base);
%shared_ptr(openplx::Vehicles::FourWheel::Base);
%shared_ptr(openplx::Vehicles::FourWheel::FrontWheelDrive);
%shared_ptr(openplx::Vehicles::FourWheel::Properties::FrontSuspensionSteering);
%shared_ptr(openplx::Vehicles::FourWheel::Properties::RearSuspension);
%shared_ptr(openplx::Vehicles::Interfaces::UpForwardVectors);
%shared_ptr(openplx::Vehicles::Steering::Articulated::Base);
%shared_ptr(openplx::Vehicles::Steering::Articulated::DualActuator);
%shared_ptr(openplx::Vehicles::Steering::Articulated::DualCylinder);
%shared_ptr(openplx::Vehicles::Steering::Base);
%shared_ptr(openplx::Vehicles::Steering::Interfaces::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Interfaces::Base);
%shared_ptr(openplx::Vehicles::Steering::Interfaces::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Interfaces::RackAndPinion);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Base);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::Base);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::RackAndPinion);
%shared_ptr(openplx::Vehicles::Suspensions::Base);
%shared_ptr(openplx::Vehicles::Suspensions::Properties::Steering);
%shared_ptr(openplx::Vehicles::Suspensions::Properties::WheelAxisFromUpForward);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Base);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Interactions::Base);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Interfaces::ChassisAttachmentConnectors);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper);
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
%shared_ptr(openplx::Vehicles::Wheels::Actuator);
%shared_ptr(openplx::Vehicles::Wheels::Base);
%shared_ptr(openplx::Vehicles::Wheels::ElasticWheel);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Rim);
%shared_ptr(openplx::Vehicles::Wheels::RimTrait);
%shared_ptr(openplx::Vehicles::Wheels::Tire);
%shared_ptr(openplx::Vehicles::Wheels::TireTrait);
OPENPLX_TRAIT(DualActuator_TraitProxy, DualActuator, openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualActuator);
OPENPLX_TRAIT(DualCylinder_TraitProxy, DualCylinder, openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualCylinder);
OPENPLX_TRAIT(ToFrames_TraitProxy, ToFrames, openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::ToFrames);
OPENPLX_TRAIT(Frames_TraitProxy, Frames, openplx::Vehicles::Chassis::Articulated::Connections::Interfaces::Frames);
OPENPLX_TRAIT(SingleJoint_TraitProxy, SingleJoint, openplx::Vehicles::Chassis::Articulated::Interfaces::SingleJoint);
OPENPLX_TRAIT(FrontSuspensionSteering_TraitProxy, FrontSuspensionSteering, openplx::Vehicles::FourWheel::Properties::FrontSuspensionSteering);
OPENPLX_TRAIT(RearSuspension_TraitProxy, RearSuspension, openplx::Vehicles::FourWheel::Properties::RearSuspension);
OPENPLX_TRAIT(UpForwardVectors_TraitProxy, UpForwardVectors, openplx::Vehicles::Interfaces::UpForwardVectors);
OPENPLX_TRAIT(Ackermann_TraitProxy, Ackermann, openplx::Vehicles::Steering::Interfaces::Ackermann);
OPENPLX_TRAIT(Base_TraitProxy, Base, openplx::Vehicles::Steering::Interfaces::Base);
OPENPLX_TRAIT(BellCrank_TraitProxy, BellCrank, openplx::Vehicles::Steering::Interfaces::BellCrank);
OPENPLX_TRAIT(RackAndPinion_TraitProxy, RackAndPinion, openplx::Vehicles::Steering::Interfaces::RackAndPinion);
OPENPLX_TRAIT(Steering_TraitProxy, Steering, openplx::Vehicles::Suspensions::Properties::Steering);
OPENPLX_TRAIT(WheelAxisFromUpForward_TraitProxy, WheelAxisFromUpForward, openplx::Vehicles::Suspensions::Properties::WheelAxisFromUpForward);
OPENPLX_TRAIT(ChassisAttachmentConnectors_TraitProxy, ChassisAttachmentConnectors, openplx::Vehicles::Suspensions::SingleMate::Interfaces::ChassisAttachmentConnectors);
OPENPLX_TRAIT(RimTrait_TraitProxy, RimTrait, openplx::Vehicles::Wheels::RimTrait);
OPENPLX_TRAIT(TireTrait_TraitProxy, TireTrait, openplx::Vehicles::Wheels::TireTrait);
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Connections::Single::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Hinge)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::SingleJoint)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Articulated::Universal)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Chassis::Rigid::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::FourWheel::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::FourWheel::FrontWheelDrive)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Articulated::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Articulated::DualActuator)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Articulated::DualCylinder)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Ackermann)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::BellCrank)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Interactions::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Steering::Kinematic::RackAndPinion)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::SingleMate::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::SingleMate::Interactions::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::Belt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::BoxLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::ContactGeometryLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CyclicVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::CylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkDescription)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DefaultLinkVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::DiscretePulseVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::FixedLinkCountBelt)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::IntertialRoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalIdler)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalRoller)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RigidCylindricalSprocket)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::RoadWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::SinusoidalVariation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Tracks::System)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Actuator)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Base)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::ElasticWheel)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Rim)
OPENPLX_FIX_DOWNCASTING(openplx::Vehicles::Wheels::Tire)
%typemap(csimports) openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base "
/* Workaround for missing namespaces on interfaces */
using ToFrames = openplx.Vehicles.Chassis.Articulated.Connections.Composite.Interfaces.ToFrames;
";
%typemap(csimports) openplx::Vehicles::Chassis::Articulated::Connections::Composite::Interfaces::DualCylinder "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Chassis::Articulated::Connections::Single::Base "
/* Workaround for missing namespaces on interfaces */
using FromTo = openplx.MachineModeling.Connections.Interfaces.FromTo;
using Frames = openplx.Vehicles.Chassis.Articulated.Connections.Interfaces.Frames;
";
%typemap(csimports) openplx::Vehicles::Chassis::Rigid::Base "
/* Workaround for missing namespaces on interfaces */
using UpForwardVectors = openplx.Vehicles.Interfaces.UpForwardVectors;
";
%typemap(csimports) openplx::Vehicles::FourWheel::Base "
/* Workaround for missing namespaces on interfaces */
using UpForwardVectors = openplx.Vehicles.Interfaces.UpForwardVectors;
";
%typemap(csimports) openplx::Vehicles::FourWheel::FrontWheelDrive "
/* Workaround for missing namespaces on interfaces */
using FrontSuspensionSteering = openplx.Vehicles.FourWheel.Properties.FrontSuspensionSteering;
using RearSuspension = openplx.Vehicles.FourWheel.Properties.RearSuspension;
";
%typemap(csimports) openplx::Vehicles::Steering::Interfaces::Ackermann "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Steering::Interfaces::BellCrank "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Steering::Interfaces::RackAndPinion "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::Ackermann "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using Ackermann = openplx.Vehicles.Steering.Interfaces.Ackermann;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::BellCrank "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using BellCrank = openplx.Vehicles.Steering.Interfaces.BellCrank;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using Ackermann = openplx.Vehicles.Steering.Interfaces.Ackermann;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::Interactions::Base "
/* Workaround for missing namespaces on interfaces */
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using BellCrank = openplx.Vehicles.Steering.Interfaces.BellCrank;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using RackAndPinion = openplx.Vehicles.Steering.Interfaces.RackAndPinion;
";
%typemap(csimports) openplx::Vehicles::Steering::Kinematic::RackAndPinion "
/* Workaround for missing namespaces on interfaces */
using Base = openplx.Vehicles.Steering.Interfaces.Base;
using RackAndPinion = openplx.Vehicles.Steering.Interfaces.RackAndPinion;
using AngleInputTrait = openplx.Physics.Signals.AngleInputTrait;
using AngleOutputTrait = openplx.Physics.Signals.AngleOutputTrait;
";
%typemap(csimports) openplx::Vehicles::Suspensions::SingleMate::Interactions::Base "
/* Workaround for missing namespaces on interfaces */
using ChassisAttachmentConnectors = openplx.Vehicles.Suspensions.SingleMate.Interfaces.ChassisAttachmentConnectors;
";
%typemap(csimports) openplx::Vehicles::Wheels::Rim "
/* Workaround for missing namespaces on interfaces */
";
%typemap(csimports) openplx::Vehicles::Wheels::Tire "
/* Workaround for missing namespaces on interfaces */
";
%include "openplx/Vehicles/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/ToFrames.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/DualActuator.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Interfaces/DualCylinder.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/OneLink.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Interfaces/Frames.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Single/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/SingleJoint.h"
%include "openplx/Vehicles/Chassis/Articulated/Hinge.h"
%include "openplx/Vehicles/Chassis/Articulated/Interfaces/SingleJoint.h"
%include "openplx/Vehicles/Chassis/Articulated/Universal.h"
%include "openplx/Vehicles/Interfaces/UpForwardVectors.h"
%include "openplx/Vehicles/Chassis/Rigid/Base.h"
%include "openplx/Vehicles/FourWheel/Base.h"
%include "openplx/Vehicles/FourWheel/Properties/FrontSuspensionSteering.h"
%include "openplx/Vehicles/FourWheel/Properties/RearSuspension.h"
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
%include "openplx/Vehicles/Steering/Base.h"
%include "openplx/Vehicles/Steering/Articulated/Base.h"
%include "openplx/Vehicles/Steering/Articulated/DualActuator.h"
%include "openplx/Vehicles/Steering/Articulated/DualCylinder.h"
%include "openplx/Vehicles/Steering/Interfaces/Base.h"
%include "openplx/Vehicles/Steering/Interfaces/Ackermann.h"
%include "openplx/Vehicles/Steering/Interfaces/BellCrank.h"
%include "openplx/Vehicles/Steering/Interfaces/RackAndPinion.h"
%include "openplx/Vehicles/Steering/Kinematic/Base.h"
%include "openplx/Vehicles/Steering/Kinematic/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Base.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/RackAndPinion.h"
%include "openplx/Vehicles/Steering/Kinematic/RackAndPinion.h"
%include "openplx/Vehicles/Suspensions/Base.h"
%include "openplx/Vehicles/Suspensions/Properties/Steering.h"
%include "openplx/Vehicles/Suspensions/Properties/WheelAxisFromUpForward.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Base.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interfaces/ChassisAttachmentConnectors.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/Base.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/LinearSpringDamper.h"
%include "openplx/Vehicles/Suspensions/SingleMate/LinearSpringDamper.h"
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Wheels/Base.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Wheels/Tire.h"
%ignore Vehicles_register_factories;
%include <openplx/Vehicles/Vehicles_all.h>
%inline {
    void Vehicles_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Vehicles_register_factories(eval_ctx);
    }
}
%template(VehiclesBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Base>>;
%template(VehiclesChassisArticulatedBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>>;
%template(VehiclesChassisArticulatedConnectionsCompositeBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>>;
%template(VehiclesChassisArticulatedConnectionsCompositeOneLinkVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>>;
%template(VehiclesChassisArticulatedConnectionsSingleBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>>;
%template(VehiclesChassisArticulatedHingeVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>>;
%template(VehiclesChassisArticulatedSingleJointVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>>;
%template(VehiclesChassisArticulatedUniversalVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>>;
%template(VehiclesChassisRigidBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>>;
%template(VehiclesFourWheelBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::Base>>;
%template(VehiclesFourWheelFrontWheelDriveVector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>;
%template(VehiclesSteeringArticulatedBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>>;
%template(VehiclesSteeringArticulatedDualActuatorVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>>;
%template(VehiclesSteeringArticulatedDualCylinderVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>>;
%template(VehiclesSteeringBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Base>>;
%template(VehiclesSteeringKinematicAckermannVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>>;
%template(VehiclesSteeringKinematicBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>>;
%template(VehiclesSteeringKinematicBellCrankVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>>;
%template(VehiclesSteeringKinematicInteractionsAckermannVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>>;
%template(VehiclesSteeringKinematicInteractionsBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>>;
%template(VehiclesSteeringKinematicInteractionsBellCrankVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>>;
%template(VehiclesSteeringKinematicInteractionsRackAndPinionVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>>;
%template(VehiclesSteeringKinematicRackAndPinionVector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>>;
%template(VehiclesSuspensionsBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Base>>;
%template(VehiclesSuspensionsSingleMateBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>>;
%template(VehiclesSuspensionsSingleMateInteractionsBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>>;
%template(VehiclesSuspensionsSingleMateInteractionsLinearSpringDamperVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>>;
%template(VehiclesSuspensionsSingleMateLinearSpringDamperVector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>>;
%template(VehiclesTracksBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%template(VehiclesTracksBoxLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%template(VehiclesTracksBoxLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%template(VehiclesTracksContactGeometryLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%template(VehiclesTracksCyclicVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%template(VehiclesTracksCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%template(VehiclesTracksCylindricalRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%template(VehiclesTracksCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%template(VehiclesTracksCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%template(VehiclesTracksDefaultLinkDescriptionVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%template(VehiclesTracksDefaultLinkVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%template(VehiclesTracksDiscretePulseVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%template(VehiclesTracksFixedLinkCountBeltVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%template(VehiclesTracksIntertialRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%template(VehiclesTracksRigidCylindricalIdlerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%template(VehiclesTracksRigidCylindricalRoadWheelBodyVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%template(VehiclesTracksRigidCylindricalRollerVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%template(VehiclesTracksRigidCylindricalSprocketVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%template(VehiclesTracksRoadWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%template(VehiclesTracksSinusoidalVariationVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%template(VehiclesTracksSystemVector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
%template(VehiclesWheelsActuatorVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>;
%template(VehiclesWheelsBaseVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Base>>;
%template(VehiclesWheelsElasticWheelVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>;
%template(VehiclesWheelsInteractionsDissipationDefaultWheelDissipationVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>;
%template(VehiclesWheelsInteractionsDissipationWheelMechanicalDampingVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>;
%template(VehiclesWheelsInteractionsFlexibilityDefaultWheelFlexibilityVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>;
%template(VehiclesWheelsInteractionsFlexibilityLinearElasticWheelFlexibilityVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>;
%template(VehiclesWheelsRimVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>;
%template(VehiclesWheelsTireVector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>;
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesBase, openplx::Vehicles::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedBase, openplx::Vehicles::Chassis::Articulated::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedConnectionsCompositeBase, openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedConnectionsCompositeOneLink, openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedConnectionsSingleBase, openplx::Vehicles::Chassis::Articulated::Connections::Single::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedHinge, openplx::Vehicles::Chassis::Articulated::Hinge)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedSingleJoint, openplx::Vehicles::Chassis::Articulated::SingleJoint)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisArticulatedUniversal, openplx::Vehicles::Chassis::Articulated::Universal)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesChassisRigidBase, openplx::Vehicles::Chassis::Rigid::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesFourWheelBase, openplx::Vehicles::FourWheel::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesFourWheelFrontWheelDrive, openplx::Vehicles::FourWheel::FrontWheelDrive)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringArticulatedBase, openplx::Vehicles::Steering::Articulated::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringArticulatedDualActuator, openplx::Vehicles::Steering::Articulated::DualActuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringArticulatedDualCylinder, openplx::Vehicles::Steering::Articulated::DualCylinder)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringBase, openplx::Vehicles::Steering::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicAckermann, openplx::Vehicles::Steering::Kinematic::Ackermann)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicBase, openplx::Vehicles::Steering::Kinematic::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicBellCrank, openplx::Vehicles::Steering::Kinematic::BellCrank)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicInteractionsAckermann, openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicInteractionsBase, openplx::Vehicles::Steering::Kinematic::Interactions::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicInteractionsBellCrank, openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicInteractionsRackAndPinion, openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSteeringKinematicRackAndPinion, openplx::Vehicles::Steering::Kinematic::RackAndPinion)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsBase, openplx::Vehicles::Suspensions::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSingleMateBase, openplx::Vehicles::Suspensions::SingleMate::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSingleMateInteractionsBase, openplx::Vehicles::Suspensions::SingleMate::Interactions::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSingleMateInteractionsLinearSpringDamper, openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesSuspensionsSingleMateLinearSpringDamper, openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBelt, openplx::Vehicles::Tracks::Belt)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBoxLinkDescription, openplx::Vehicles::Tracks::BoxLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksBoxLinkVariation, openplx::Vehicles::Tracks::BoxLinkVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksContactGeometryLinkDescription, openplx::Vehicles::Tracks::ContactGeometryLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCyclicVariation, openplx::Vehicles::Tracks::CyclicVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalIdler, openplx::Vehicles::Tracks::CylindricalIdler)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalRoadWheel, openplx::Vehicles::Tracks::CylindricalRoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalRoller, openplx::Vehicles::Tracks::CylindricalRoller)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksCylindricalSprocket, openplx::Vehicles::Tracks::CylindricalSprocket)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDefaultLinkDescription, openplx::Vehicles::Tracks::DefaultLinkDescription)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDefaultLinkVariation, openplx::Vehicles::Tracks::DefaultLinkVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksDiscretePulseVariation, openplx::Vehicles::Tracks::DiscretePulseVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksFixedLinkCountBelt, openplx::Vehicles::Tracks::FixedLinkCountBelt)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksIntertialRoadWheel, openplx::Vehicles::Tracks::IntertialRoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalIdler, openplx::Vehicles::Tracks::RigidCylindricalIdler)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalRoadWheelBody, openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalRoller, openplx::Vehicles::Tracks::RigidCylindricalRoller)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRigidCylindricalSprocket, openplx::Vehicles::Tracks::RigidCylindricalSprocket)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksRoadWheel, openplx::Vehicles::Tracks::RoadWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksSinusoidalVariation, openplx::Vehicles::Tracks::SinusoidalVariation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesTracksSystem, openplx::Vehicles::Tracks::System)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsActuator, openplx::Vehicles::Wheels::Actuator)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsBase, openplx::Vehicles::Wheels::Base)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsElasticWheel, openplx::Vehicles::Wheels::ElasticWheel)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsDissipationDefaultWheelDissipation, openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsDissipationWheelMechanicalDamping, openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsFlexibilityDefaultWheelFlexibility, openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsInteractionsFlexibilityLinearElasticWheelFlexibility, openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsRim, openplx::Vehicles::Wheels::Rim)
OPENPLX_OPTIONAL_SHARED_PTR(OptionalVehiclesWheelsTire, openplx::Vehicles::Wheels::Tire)
