/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/agxPhysics_export.h>
#include <agx/TimeStamp.h>

#include <agxCollide/Contacts.h>

#include <agxSDK/ExecuteFilter.h>
#include <agxSDK/ContactEventListener.h>

namespace agxUtil
{

  /**
  This is a utility class that disables ContactPoints where the contact normal prevents
  movement along the surface velocity direction.

  A usecase for this class can be when multiple shapes are placed after each other to form
  a conveyor belt structure. When the transition from one shape to the next occurs, the
  object moving along the conveyor belt can collide so there are two types of contact normals:
  "vertical / stay ontop of the conveyor belt" as well as "horizontal / don't move into this object".
  The reason for this is that the overlap tests are done pairwise.

  This contact listener disables the contact points that prevents the transportation along
  surface velocity direction.
  */
  class AGXPHYSICS_EXPORT SurfaceVelocityContactFilter : public agxSDK::ContactEventListener
  {
    public:

      SurfaceVelocityContactFilter(agxSDK::ExecuteFilter* filter = nullptr );

      virtual KeepContactPolicy impact(const agx::TimeStamp& time, agxCollide::GeometryContact *geometryContact) override;

      virtual KeepContactPolicy contact(const agx::TimeStamp& time, agxCollide::GeometryContact* geometryContact) override;

    private:
      void processContact(agxCollide::GeometryContact* geometryContact);

  };


}
