/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once

#include <agxSDK/Simulation.h>
#include <agx/Material.h>

#include <agxTerrain/FailureSurfaceAggregate.h>
#include <agxTerrain/GroundCollapseResult.h>
#include <agxTerrain/GroundCollapseUtils.h>
#include <agxTerrain/CollapseSettings.h>


namespace agxTerrain
{
  class Terrain;

  namespace GroundCollapse
  {
    DOXYGEN_START_INTERNAL_BLOCK()
    AGX_DECLARE_POINTER_TYPES(CollapseSimulation);
    AGX_DECLARE_VECTOR_TYPES(CollapseSimulation);

    class AGXTERRAIN_EXPORT CollapseSimulation : public agx::Referenced
    {
    public:
      CollapseSimulation(agxTerrain::Terrain* terrain,
                         GroundCollapse::CollapseSettings* settings);

      bool addContactData( const ContactData& contactData );

      void updateMaterialPool();

      void simPreContactCallback();

      void postSolve( agx::UInt substep,
                      FailureSurfaceResultVector& subStepResultVector,
                      GroundCollapse::CollapseSettings* settings,
                      GroundCollapse::CollapseRenderSettings* renderSettings );

      void postSolveSingle( SubStepResult& subStepResult );

      void step();

      void cleanUp();

      void lastUpdatePool();

      void initCustomMaterials();

      void updateFromSettings( GroundCollapse::CollapseSettings* settings );

      agx::ContactMaterial* getContactMaterial() const { return m_customContactMaterial; };

      agxSDK::Simulation* getSimulation() const { return m_simulation; };

      agx::ContactMaterial* createContactMaterial( const agx::ContactMaterial* originalCM );

      size_t getNumAddedAggregates() { return m_aggregateContacts.size(); };

      const ContactDataVector& getContactData() { return m_aggregateContacts; };

    private:
      agxTerrain::Terrain*        m_terrain;
      agxSDK::SimulationRef       m_simulation;
      ContactDataVector           m_aggregateContacts;
      agxCollide::GeometryRef     m_ghostTerrainGeometry;
      agx::MaterialRef            m_customMaterial;
      agx::ContactMaterialRef     m_customContactMaterial;

      agx::Vector<agx::ContactMaterialRef> m_temporaryContactMaterials;
      agx::Vector<agx::ContactMaterialRef> m_contactMaterialPool;
      bool                                 m_useHolonomicContacts;
    };
    DOXYGEN_END_INTERNAL_BLOCK()
  }
}