/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/Sensor.h>

#include <agx/Constraint.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( ConstraintAttachedSensor );
  AGX_DECLARE_VECTOR_TYPES( ConstraintAttachedSensor );

  /**
  Common base type for all sensors attached to a constraint between two bodies.
  */
  class AGXSENSOR_EXPORT ConstraintAttachedSensor : public Sensor
  {
    public:
      /**
      Default constructor.
      */
      ConstraintAttachedSensor() = default;

      /**
      Assign a new parent constraint to attach this sensor to. The effects will take place the next
      time the environment is stepped.
      \param constraint - new constraint for this sensor
      */
      virtual void setConstraint( agx::Constraint* constraint ) = 0;

      /**
      \return the constraint of this sensor, defining what the encoder is attached to
      */
      virtual agx::Constraint* getConstraint() const = 0;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      AGXSTREAM_DECLARE_ABSTRACT_SERIALIZABLE( agxSensor::ConstraintAttachedSensor );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
