/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once

#include "agx/config/AGX_USE_AGXSENSOR.h"

#include "agxROS2/export.h"
#include "agxROS2/MessageTypes.h"

#if AGX_USE_AGXSENSOR()
#include "agxSensor/RaytraceOutput.h"
#endif

namespace agxROS2
{
    /**
    Free the memory held by the given container by swapping it with a
    default-constructed instance.

    This is required when an application is using a different system allocator
    than the AGX Dynamics shared library and a container is passed by-value
    from AGX Dynamics to the application. When the container goes out of scope
    the application's system allocator will try to deallocate the container's
    buffer, a buffer that was allocated with AGX Dynamics' system allocator.
    This will either cause memory errors or a crash. By first calling
    freeContainerMemory the buffer will be freed inside AGX Dynamics, with
    AGX Dynamics' system allocator, and the application's system allocator will
    not need to do anything.
    */
    template<typename ContainerT>
    void freeContainerMemory(ContainerT& container);
    
#if AGX_USE_AGXSENSOR()
    /**
    Uses an output from agxSensor's lidar module to create an equivalent 
    ROS2 PointCloud2 message. This splits vector fields into single elements
    and names each new field according to the field they came from in AGX.

    \param lidarOutput A raytracing output
    \param timestamp The timestamp to write into the ROS2 message header
    \param frameId The frame id to write into the ROS2 message header
    \param isDense A bool signifying when true that misses are excluded in the output. The value of this parameter 
                   should be derived from the RtOutputHander instance the output is sourced from.
    \param height The height of the 2D array of points represented in the output. Can be used to define an organized
                  point cloud. Unless \p isDense is true, this value is used as the height in the resulting message
                  and the width is deduced from the size of the output.
    */
    AGXROS2_EXPORT sensorMsgs::PointCloud2 convertLidarOutput(agxSensor::RtOutput* lidarOutput, double timestamp, 
                                                              std::string frameId, bool isDense, uint32_t height = 1);
#endif
}
