/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <vector>
#include <openplx/Object.h>
#include <openplx/Physics3D/System.h>
#include <agxOpenPLX/export.h>

namespace openplx::Physics::Signals
{
  class Input;
  class Output;
}

namespace agxopenplx
{

  using InputSignalPtr = std::shared_ptr<openplx::Physics::Signals::InputSignal>;
  using OutputSignalPtr = std::shared_ptr<openplx::Physics::Signals::OutputSignal>;

  class InputSignalQueue
  {

    public:
      AGXOPENPLX_EXPORT static std::shared_ptr<InputSignalQueue> create();

      AGXOPENPLX_EXPORT void send(InputSignalPtr signal);
      AGXOPENPLX_EXPORT const std::vector<InputSignalPtr>& getSignals() const;
      AGXOPENPLX_EXPORT std::vector<InputSignalPtr> popSignals();
      AGXOPENPLX_EXPORT void clear();
      AGXOPENPLX_EXPORT size_t size() const;
      AGXOPENPLX_EXPORT bool empty() const;

    private:
      InputSignalQueue() = default;

      std::vector<InputSignalPtr> m_queue;
  };

  class OutputSignalQueue
  {

    public:
      enum class OutputCompareStrategy
      {
        Pointer,
        Name,
        Uuid
      };

      AGXOPENPLX_EXPORT static std::shared_ptr<OutputSignalQueue> create();

      AGXOPENPLX_EXPORT void send(OutputSignalPtr signal);
      AGXOPENPLX_EXPORT const std::vector<OutputSignalPtr>& getSignals() const;
      AGXOPENPLX_EXPORT std::vector<OutputSignalPtr> popSignals();
      AGXOPENPLX_EXPORT void clear();
      AGXOPENPLX_EXPORT size_t size() const;
      AGXOPENPLX_EXPORT bool empty() const;
      AGXOPENPLX_EXPORT std::unordered_map<std::string, OutputSignalPtr> getSignalsForInterface(
        const std::shared_ptr<openplx::Physics::Signals::SignalInterface>& signal_interface,
        OutputCompareStrategy compare_strategy = OutputCompareStrategy::Uuid) const;

    private:
      OutputSignalQueue() = default;

      std::vector<OutputSignalPtr> m_queue;
  };
}
