#pragma once

#include <openplx/OutputHandler.h>

namespace openplx {
    class Marshalling;

    namespace Physics::Signals {
        class Output;
    }
}

namespace agxopenplx {

    class AgxObjectMap;
    class AgxMetadata;

    class LidarOutputHandler : public openplx::OutputHandler {
        public:

            LidarOutputHandler(std::shared_ptr<AgxObjectMap> mapper, std::shared_ptr<AgxMetadata> metadata);

            bool handle(
                const std::shared_ptr<openplx::Physics::Signals::Output>& output,
                const std::shared_ptr<openplx::Marshalling>& marshalling) override;
        private:
            std::shared_ptr<AgxObjectMap> m_mapper;
            std::shared_ptr<AgxMetadata> m_metadata;
    };
}
