/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <agxSDK/Assembly.h>
#include <agxSDK/Simulation.h>
#include <openplx/Document.h>
#include <openplx/ErrorReporter.h>
#include <openplx/Import.h>
#include <openplx/Plugin.h>
#include <openplx/Logger.h>
#include <agxOpenPLX/AgxCache.h>
#include <agxOpenPLX/export.h>

namespace agxopenplx
{

  /**
   * openplx plugin for .agx and .aagx files, runs from openplx core api to process 'import @"file.agx"'
   * or 'import @"file.aagx"' directives and convert them
   * to .openplx code. Large instances like meshes are cached to avoid loading them twice.
   */
  class AGXOPENPLX_EXPORT AgxPlugin : public openplx::Plugin
  {
    public:
      AgxPlugin(std::shared_ptr<agxopenplx::AgxCache> cache);

      openplx::DocPtr parse(
        const std::string& key, openplx::ImportPtr import_node, openplx::ErrorReporter& error_reporter) override;
      std::vector<std::string> extensions() override;
      void setPrecision(int precision) override;
      void setLogger(std::shared_ptr<openplx::Logger> logger) override;

      bool keyShouldBeSource() override;

    private:
      void cacheGeometries(const agxSDK::AssemblyRef& assembly);
      std::shared_ptr<agxopenplx::AgxCache> m_cache;
      agxSDK::SimulationRef m_cache_simulation;
      int m_precision;
  };
}
