/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxOSG/ExampleApplication.h>
#include <agxOSG/Node.h>
#include <agxOpenPLX/AgxOpenPlxApi.h>

namespace agxopenplx {
    /**
     * Adds visuals to the resulting Scene:
     * - if the Visuals bundle was explicitly used
     * - for Terrains
     *
     * @param result The result from loading the openplx scene
     * @param osg_root The OSG root
     */
    AGXOSG_EXPORT void addVisuals(agxopenplx::LoadResult result, osg::Group* osg_root);

    /**
     * @brief Adds visual updater for deformable trimeshes. Must be called after addVisuals and after the scene is added to the simulation
     *
     * @param result
     * @param osg_root
     */
    AGXOSG_EXPORT void addDeformableVisualUpdaters(agxopenplx::LoadResult result, osg::Group* osg_root);

    AGXOSG_EXPORT void add_file_changed_listener(agxOSG::ExampleApplication* app, const std::string& openplxfile);
}
