// Copyright 2026, Algoryx Simulation AB.

#pragma once

// Unreal Engine includes.
#include "CoreMinimal.h"

// Standard library includes.
#include <memory>

#include "CableBarrier.generated.h"

struct FAGX_CableNodeInfo;
struct FCableNodeBarrier;
struct FCablePropertiesBarrier;
struct FCableRef;

USTRUCT(BlueprintType)
struct AGXUNREALBARRIER_API FCableBarrier
{
	GENERATED_BODY()

	FCableBarrier();
	FCableBarrier(std::shared_ptr<FCableRef> Native);

	void AllocateNative(double Radius, double SegmentLength);
	bool Add(FCableNodeBarrier& Node);

	void SetCableProperties(FCablePropertiesBarrier& Properties);
	FCablePropertiesBarrier GetCableProperties() const;

	void SetCablePropertiesToDefault();

	TArray<FAGX_CableNodeInfo> GetNodeInfo() const;

	double GetRadius() const;
	double GetSegmentLength() const;

	FGuid GetGuid() const;

	void SetName(const FString& NewName);
	FString GetName() const;

	void AddCollisionGroup(const FName& GroupName);
	void AddCollisionGroups(const TArray<FName>& GroupNames);
	TArray<FName> GetCollisionGroups() const;
	void RemoveCollisionGroup(const FName& GroupName);

	bool HasNative() const;
	FCableRef* GetNative();
	const FCableRef* GetNative() const;

	/// @return The address of the underlying AGX Dynamics object.
	uintptr_t GetNativeAddress() const;

	/// Re-assign this Barrier to the given native address. The address must be an existing AGX
	/// Dynamics object of the correct type.
	void SetNativeAddress(uintptr_t NativeAddress);

	void ReleaseNative();

private:
	std::shared_ptr<FCableRef> NativeRef;
};
