%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles(prefix)
%rename(prefix ## Vehicle) openplx::Vehicles::Vehicle;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles()
%shared_ptr(openplx::Vehicles::Vehicle);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles()
%typemap(out) std::shared_ptr<openplx::Vehicles::Vehicle> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles()
%template(Vehicles_Vehicle_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Vehicle>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Vehicle>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Vehicle>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Vehicle>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Vehicle>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Vehicle>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Vehicle>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles()
%include "openplx/Vehicles/Vehicle.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles()
%pythoncode %{
from . import FourWheel
from . import Steering
from . import Suspensions
from . import Tracks
from . import Wheels
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_FourWheel()
%import "Vehicles.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_FourWheel()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel(prefix)
%rename(prefix ## FrontWheelDrive) openplx::Vehicles::FourWheel::FrontWheelDrive;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel()
%shared_ptr(openplx::Vehicles::FourWheel::FrontWheelDrive);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel()
%typemap(out) std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel()
%template(Vehicles_FourWheel_FrontWheelDrive_Vector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel()
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_FourWheel()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_FourWheel_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_FourWheel_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_FourWheel_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering_Interactions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Interactions(prefix)
%rename(prefix ## Ackermann) openplx::Vehicles::Steering::Interactions::Ackermann;
%rename(prefix ## BellCrank) openplx::Vehicles::Steering::Interactions::BellCrank;
%rename(prefix ## DualSuspensionSteering) openplx::Vehicles::Steering::Interactions::DualSuspensionSteering;
%rename(prefix ## RackAndPinion) openplx::Vehicles::Steering::Interactions::RackAndPinion;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Interactions()
%shared_ptr(openplx::Vehicles::Steering::Interactions::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Interactions::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Interactions::DualSuspensionSteering);
%shared_ptr(openplx::Vehicles::Steering::Interactions::RackAndPinion);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Interactions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Interactions()
%template(Vehicles_Steering_Interactions_Ackermann_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Interactions_BellCrank_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Interactions_DualSuspensionSteering_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::DualSuspensionSteering>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Interactions_RackAndPinion_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Interactions::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Interactions()
%include "openplx/Vehicles/Steering/Interactions/DualSuspensionSteering.h"
%include "openplx/Vehicles/Steering/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Interactions/RackAndPinion.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering_Interactions()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions(prefix)
%rename(prefix ## LinearSpringDamper) openplx::Vehicles::Suspensions::LinearSpringDamper;
%rename(prefix ## SingleMateSuspension) openplx::Vehicles::Suspensions::SingleMateSuspension;
%rename(prefix ## Suspension) openplx::Vehicles::Suspensions::Suspension;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions()
%shared_ptr(openplx::Vehicles::Suspensions::LinearSpringDamper);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMateSuspension);
%shared_ptr(openplx::Vehicles::Suspensions::Suspension);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions()
%template(Vehicles_Suspensions_LinearSpringDamper_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_SingleMateSuspension_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_Suspension_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Suspension>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions()
%include "openplx/Vehicles/Suspensions/Suspension.h"
%include "openplx/Vehicles/Suspensions/SingleMateSuspension.h"
%include "openplx/Vehicles/Suspensions/LinearSpringDamper.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions()
%pythoncode %{
from . import Interactions
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_Interactions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Interactions(prefix)
%rename(prefix ## Connector) openplx::Vehicles::Suspensions::Interactions::Connector;
%rename(prefix ## LinearSpringDamperMate) openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate;
%rename(prefix ## Mate) openplx::Vehicles::Suspensions::Interactions::Mate;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Interactions()
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::Connector);
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate);
%shared_ptr(openplx::Vehicles::Suspensions::Interactions::Mate);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Interactions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Interactions()
%template(Vehicles_Suspensions_Interactions_Connector_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Connector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_Interactions_LinearSpringDamperMate_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::LinearSpringDamperMate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_Interactions_Mate_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Interactions()
%include "openplx/Vehicles/Suspensions/Interactions/Connector.h"
%include "openplx/Vehicles/Suspensions/Interactions/Mate.h"
%include "openplx/Vehicles/Suspensions/Interactions/LinearSpringDamperMate.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_Interactions()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Tracks()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Tracks()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix)
%rename(prefix ## Belt) openplx::Vehicles::Tracks::Belt;
%rename(prefix ## BoxLinkDescription) openplx::Vehicles::Tracks::BoxLinkDescription;
%rename(prefix ## BoxLinkVariation) openplx::Vehicles::Tracks::BoxLinkVariation;
%rename(prefix ## ContactGeometryLinkDescription) openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%rename(prefix ## CyclicVariation) openplx::Vehicles::Tracks::CyclicVariation;
%rename(prefix ## CylindricalIdler) openplx::Vehicles::Tracks::CylindricalIdler;
%rename(prefix ## CylindricalRoadWheel) openplx::Vehicles::Tracks::CylindricalRoadWheel;
%rename(prefix ## CylindricalRoller) openplx::Vehicles::Tracks::CylindricalRoller;
%rename(prefix ## CylindricalSprocket) openplx::Vehicles::Tracks::CylindricalSprocket;
%rename(prefix ## DefaultLinkDescription) openplx::Vehicles::Tracks::DefaultLinkDescription;
%rename(prefix ## DefaultLinkVariation) openplx::Vehicles::Tracks::DefaultLinkVariation;
%rename(prefix ## DiscretePulseVariation) openplx::Vehicles::Tracks::DiscretePulseVariation;
%rename(prefix ## FixedLinkCountBelt) openplx::Vehicles::Tracks::FixedLinkCountBelt;
%rename(prefix ## IntertialRoadWheel) openplx::Vehicles::Tracks::IntertialRoadWheel;
%rename(prefix ## RigidCylindricalIdler) openplx::Vehicles::Tracks::RigidCylindricalIdler;
%rename(prefix ## RigidCylindricalRoadWheelBody) openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%rename(prefix ## RigidCylindricalRoller) openplx::Vehicles::Tracks::RigidCylindricalRoller;
%rename(prefix ## RigidCylindricalSprocket) openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%rename(prefix ## RoadWheel) openplx::Vehicles::Tracks::RoadWheel;
%rename(prefix ## SinusoidalVariation) openplx::Vehicles::Tracks::SinusoidalVariation;
%rename(prefix ## System) openplx::Vehicles::Tracks::System;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks()
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks()
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::Belt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::System> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks()
%template(Vehicles_Tracks_Belt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_ContactGeometryLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CyclicVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DiscretePulseVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_FixedLinkCountBelt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_IntertialRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoadWheelBody_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_SinusoidalVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_System_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks()
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Tracks()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels(prefix)
%rename(prefix ## Actuator) openplx::Vehicles::Wheels::Actuator;
%rename(prefix ## ElasticWheel) openplx::Vehicles::Wheels::ElasticWheel;
%rename(prefix ## Rim) openplx::Vehicles::Wheels::Rim;
%rename(prefix ## Tire) openplx::Vehicles::Wheels::Tire;
%rename(prefix ## Wheel) openplx::Vehicles::Wheels::Wheel;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels()
%shared_ptr(openplx::Vehicles::Wheels::Actuator);
%shared_ptr(openplx::Vehicles::Wheels::ElasticWheel);
%shared_ptr(openplx::Vehicles::Wheels::Rim);
%shared_ptr(openplx::Vehicles::Wheels::Tire);
%shared_ptr(openplx::Vehicles::Wheels::Wheel);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Actuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Rim> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Tire> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Wheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels()
%template(Vehicles_Wheels_Actuator_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_ElasticWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Rim_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Rim>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Rim>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Rim>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Rim>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Tire_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Tire>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Tire>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Tire>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Tire>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Wheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Wheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Wheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Wheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Wheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Wheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Wheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Wheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels()
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Wheels/Wheel.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Wheels/Tire.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels()
%pythoncode %{
from . import Interactions
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels_Interactions_Dissipation()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels_Interactions_Dissipation()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Dissipation(prefix)
%rename(prefix ## DefaultWheelDissipation) openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation;
%rename(prefix ## WheelMechanicalDamping) openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Dissipation()
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Dissipation()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Dissipation()
%template(Vehicles_Wheels_Interactions_Dissipation_DefaultWheelDissipation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Interactions_Dissipation_WheelMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Dissipation()
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels_Interactions_Dissipation()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels_Interactions_Flexibility()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels_Interactions_Flexibility()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Flexibility(prefix)
%rename(prefix ## DefaultWheelFlexibility) openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility;
%rename(prefix ## LinearElasticWheelFlexibility) openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Flexibility()
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Flexibility()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Flexibility()
%template(Vehicles_Wheels_Interactions_Flexibility_DefaultWheelFlexibility_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Interactions_Flexibility_LinearElasticWheelFlexibility_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Flexibility()
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels_Interactions_Flexibility()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Vehicles()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Vehicles()
%import "Vehicles.i"
%import "Vehicles_FourWheel.i"
%import "Vehicles_FourWheel_Traits.i"
%import "Vehicles_Steering_Interactions.i"
%import "Vehicles_Suspensions.i"
%import "Vehicles_Suspensions_Interactions.i"
%import "Vehicles_Suspensions_Traits.i"
%import "Vehicles_Tracks.i"
%import "Vehicles_Wheels.i"
%import "Vehicles_Wheels_Interactions_Dissipation.i"
%import "Vehicles_Wheels_Interactions_Flexibility.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Vehicles()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Vehicles()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Vehicles(prefix)
OPENPLX_SWIG_NS_RENAMES_Vehicles(prefix);
OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel(prefix ## FourWheel_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel_Traits(prefix ## FourWheel_Traits_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Interactions(prefix ## Steering_Interactions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions(prefix ## Suspensions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Interactions(prefix ## Suspensions_Interactions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Traits(prefix ## Suspensions_Traits_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix ## Tracks_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels(prefix ## Wheels_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Dissipation(prefix ## Wheels_Interactions_Dissipation_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Flexibility(prefix ## Wheels_Interactions_Flexibility_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Vehicles()
OPENPLX_SWIG_NS_VECTORS_Vehicles();
OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel_Traits();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Interactions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Interactions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Traits();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Vehicles()
OPENPLX_SWIG_NS_INCLUDES_Vehicles();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel_Traits();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Traits();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Flexibility();
%enddef

