%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Simulation()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Simulation()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Simulation(prefix)
%rename(prefix ## CollisionGroup) openplx::Simulation::CollisionGroup;
%rename(prefix ## DisableCollisionPair) openplx::Simulation::DisableCollisionPair;
%rename(prefix ## Environment) openplx::Simulation::Environment;
%rename(prefix ## GravitationalField) openplx::Simulation::GravitationalField;
%rename(prefix ## PointGravitationalField) openplx::Simulation::PointGravitationalField;
%rename(prefix ## UniformGravitationalField) openplx::Simulation::UniformGravitationalField;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Simulation()
%shared_ptr(openplx::Simulation::CollisionGroup);
%shared_ptr(openplx::Simulation::DisableCollisionPair);
%shared_ptr(openplx::Simulation::Environment);
%shared_ptr(openplx::Simulation::GravitationalField);
%shared_ptr(openplx::Simulation::PointGravitationalField);
%shared_ptr(openplx::Simulation::UniformGravitationalField);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Simulation()
%typemap(out) std::shared_ptr<openplx::Simulation::CollisionGroup> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Simulation::DisableCollisionPair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Simulation::Environment> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Simulation::GravitationalField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Simulation::PointGravitationalField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Simulation::UniformGravitationalField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Simulation()
%template(Simulation_CollisionGroup_Vector) std::vector<std::shared_ptr<openplx::Simulation::CollisionGroup>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::CollisionGroup>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::CollisionGroup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::CollisionGroup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::CollisionGroup>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::CollisionGroup>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::CollisionGroup>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Simulation_DisableCollisionPair_Vector) std::vector<std::shared_ptr<openplx::Simulation::DisableCollisionPair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::DisableCollisionPair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::DisableCollisionPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::DisableCollisionPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::DisableCollisionPair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::DisableCollisionPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::DisableCollisionPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Simulation_Environment_Vector) std::vector<std::shared_ptr<openplx::Simulation::Environment>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::Environment>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::Environment>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::Environment>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::Environment>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::Environment>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::Environment>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Simulation_GravitationalField_Vector) std::vector<std::shared_ptr<openplx::Simulation::GravitationalField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::GravitationalField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::GravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::GravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::GravitationalField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::GravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::GravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Simulation_PointGravitationalField_Vector) std::vector<std::shared_ptr<openplx::Simulation::PointGravitationalField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::PointGravitationalField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::PointGravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::PointGravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::PointGravitationalField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::PointGravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::PointGravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Simulation_UniformGravitationalField_Vector) std::vector<std::shared_ptr<openplx::Simulation::UniformGravitationalField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Simulation::UniformGravitationalField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Simulation::UniformGravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::UniformGravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Simulation::UniformGravitationalField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Simulation::UniformGravitationalField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Simulation::UniformGravitationalField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Simulation()
%include "openplx/Simulation/CollisionGroup.h"
%include "openplx/Simulation/DisableCollisionPair.h"
%include "openplx/Simulation/Environment.h"
%include "openplx/Simulation/GravitationalField.h"
%include "openplx/Simulation/PointGravitationalField.h"
%include "openplx/Simulation/UniformGravitationalField.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Simulation()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Simulation()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Simulation()
%import "Simulation.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Simulation()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Simulation()
%import "Math.i"
%import "Physics.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Simulation(prefix)
OPENPLX_SWIG_NS_RENAMES_Simulation(prefix);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Simulation()
OPENPLX_SWIG_NS_SHARED_POINTERS_Simulation();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Simulation()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Simulation();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Simulation()
OPENPLX_SWIG_NS_VECTORS_Simulation();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Simulation()
OPENPLX_SWIG_NS_INCLUDES_Simulation();
%enddef

