%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics(prefix)
%rename(prefix ## KinematicLock) openplx::Physics::KinematicLock;
%rename(prefix ## System) openplx::Physics::System;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics()
%shared_ptr(openplx::Physics::KinematicLock);
%shared_ptr(openplx::Physics::System);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics()
%typemap(out) std::shared_ptr<openplx::Physics::KinematicLock> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::System> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics()
%template(Physics_KinematicLock_Vector) std::vector<std::shared_ptr<openplx::Physics::KinematicLock>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::KinematicLock>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::KinematicLock>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::KinematicLock>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::KinematicLock>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::KinematicLock>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::KinematicLock>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_System_Vector) std::vector<std::shared_ptr<openplx::Physics::System>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::System>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::System>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics()
%include "openplx/Physics/KinematicLock.h"
%include "openplx/Physics/System.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics()
%pythoncode %{
from . import Bodies
from . import Geometries
from . import Interactions
from . import Optics
from . import Signals
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Bodies()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Bodies()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Bodies(prefix)
%rename(prefix ## Body) openplx::Physics::Bodies::Body;
%rename(prefix ## Inertia) openplx::Physics::Bodies::Inertia;
%rename(prefix ## Kinematics) openplx::Physics::Bodies::Kinematics;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Bodies()
%shared_ptr(openplx::Physics::Bodies::Body);
%shared_ptr(openplx::Physics::Bodies::Inertia);
%shared_ptr(openplx::Physics::Bodies::Kinematics);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Bodies()
%typemap(out) std::shared_ptr<openplx::Physics::Bodies::Body> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Bodies::Inertia> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Bodies::Kinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Bodies()
%template(Physics_Bodies_Body_Vector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Bodies::Body>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Bodies_Inertia_Vector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Inertia>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Bodies::Inertia>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Bodies::Inertia>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Bodies_Kinematics_Vector) std::vector<std::shared_ptr<openplx::Physics::Bodies::Kinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Bodies::Kinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Bodies::Kinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Bodies()
%include "openplx/Physics/Bodies/Body.h"
%include "openplx/Physics/Bodies/Inertia.h"
%include "openplx/Physics/Bodies/Kinematics.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Bodies()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Geometries()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Geometries()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Geometries(prefix)
%rename(prefix ## ContactGeometry) openplx::Physics::Geometries::ContactGeometry;
%rename(prefix ## LinearElasticMaterial) openplx::Physics::Geometries::LinearElasticMaterial;
%rename(prefix ## Material) openplx::Physics::Geometries::Material;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Geometries()
%shared_ptr(openplx::Physics::Geometries::ContactGeometry);
%shared_ptr(openplx::Physics::Geometries::LinearElasticMaterial);
%shared_ptr(openplx::Physics::Geometries::Material);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Geometries()
%typemap(out) std::shared_ptr<openplx::Physics::Geometries::ContactGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Geometries::Material> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Geometries()
%template(Physics_Geometries_ContactGeometry_Vector) std::vector<std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::ContactGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Geometries_LinearElasticMaterial_Vector) std::vector<std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::LinearElasticMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Geometries_Material_Vector) std::vector<std::shared_ptr<openplx::Physics::Geometries::Material>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Geometries::Material>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Geometries::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Geometries::Material>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Geometries::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Geometries::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Geometries()
%include "openplx/Physics/Geometries/ContactGeometry.h"
%include "openplx/Physics/Geometries/Material.h"
%include "openplx/Physics/Geometries/LinearElasticMaterial.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Geometries()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions(prefix)
%rename(prefix ## Connector) openplx::Physics::Interactions::Connector;
%rename(prefix ## Interaction) openplx::Physics::Interactions::Interaction;
%rename(prefix ## Interaction1DOF) openplx::Physics::Interactions::Interaction1DOF;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions()
%shared_ptr(openplx::Physics::Interactions::Connector);
%shared_ptr(openplx::Physics::Interactions::Interaction);
%shared_ptr(openplx::Physics::Interactions::Interaction1DOF);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Connector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Interaction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions()
%template(Physics_Interactions_Connector_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Connector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Connector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Connector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Connector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Connector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Connector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Connector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Interaction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Interaction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Interaction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Interaction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Interaction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Interaction1DOF_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Interaction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions()
%include "openplx/Physics/Interactions/Connector.h"
%include "openplx/Physics/Interactions/Interaction.h"
%include "openplx/Physics/Interactions/Interaction1DOF.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions()
%pythoncode %{
from . import Adhesion
from . import Clearance
from . import Dissipation
from . import Flexibility
from . import SurfaceContact
from . import Toughness
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_Adhesion()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_Adhesion()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Adhesion(prefix)
%rename(prefix ## ConstantForceAdhesion) openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion;
%rename(prefix ## DefaultAdhesion) openplx::Physics::Interactions::Adhesion::DefaultAdhesion;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Adhesion()
%shared_ptr(openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion);
%shared_ptr(openplx::Physics::Interactions::Adhesion::DefaultAdhesion);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Adhesion()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Adhesion()
%template(Physics_Interactions_Adhesion_ConstantForceAdhesion_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Adhesion::ConstantForceAdhesion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Adhesion_DefaultAdhesion_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Adhesion::DefaultAdhesion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Adhesion()
%include "openplx/Physics/Interactions/Adhesion/DefaultAdhesion.h"
%include "openplx/Physics/Interactions/Adhesion/ConstantForceAdhesion.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_Adhesion()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_Clearance()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_Clearance()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Clearance(prefix)
%rename(prefix ## ConstantAngleClearance) openplx::Physics::Interactions::Clearance::ConstantAngleClearance;
%rename(prefix ## ConstantDistanceClearance) openplx::Physics::Interactions::Clearance::ConstantDistanceClearance;
%rename(prefix ## DefaultClearance) openplx::Physics::Interactions::Clearance::DefaultClearance;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Clearance()
%shared_ptr(openplx::Physics::Interactions::Clearance::ConstantAngleClearance);
%shared_ptr(openplx::Physics::Interactions::Clearance::ConstantDistanceClearance);
%shared_ptr(openplx::Physics::Interactions::Clearance::DefaultClearance);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Clearance()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Clearance()
%template(Physics_Interactions_Clearance_ConstantAngleClearance_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantAngleClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Clearance_ConstantDistanceClearance_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::ConstantDistanceClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Clearance_DefaultClearance_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Clearance::DefaultClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Clearance()
%include "openplx/Physics/Interactions/Clearance/DefaultClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantAngleClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantDistanceClearance.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_Clearance()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_Dissipation()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_Dissipation()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Dissipation(prefix)
%rename(prefix ## AsymmetricLimitFriction) openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction;
%rename(prefix ## ConstantLimitFriction) openplx::Physics::Interactions::Dissipation::ConstantLimitFriction;
%rename(prefix ## ConstantViscousSurfaceFriction) openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction;
%rename(prefix ## ConstraintRelaxationTimeDamping) openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping;
%rename(prefix ## DefaultDissipation) openplx::Physics::Interactions::Dissipation::DefaultDissipation;
%rename(prefix ## DefaultDryFriction) openplx::Physics::Interactions::Dissipation::DefaultDryFriction;
%rename(prefix ## DefaultFriction) openplx::Physics::Interactions::Dissipation::DefaultFriction;
%rename(prefix ## DryBoxFriction) openplx::Physics::Interactions::Dissipation::DryBoxFriction;
%rename(prefix ## DryConeFriction) openplx::Physics::Interactions::Dissipation::DryConeFriction;
%rename(prefix ## DryConstantNormalForceFriction) openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction;
%rename(prefix ## DryDepthScaledConstantNormalForceFriction) openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction;
%rename(prefix ## DryScaleBoxFriction) openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction;
%rename(prefix ## MechanicalDamping) openplx::Physics::Interactions::Dissipation::MechanicalDamping;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Dissipation()
%shared_ptr(openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstantLimitFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultDissipation);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultDryFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DefaultFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryBoxFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryConeFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction);
%shared_ptr(openplx::Physics::Interactions::Dissipation::MechanicalDamping);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Dissipation()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Dissipation()
%template(Physics_Interactions_Dissipation_AsymmetricLimitFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::AsymmetricLimitFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_ConstantLimitFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantLimitFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_ConstantViscousSurfaceFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstantViscousSurfaceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_ConstraintRelaxationTimeDamping_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::ConstraintRelaxationTimeDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DefaultDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DefaultDryFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDryFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DefaultFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DryBoxFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryBoxFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DryConeFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConeFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DryConstantNormalForceFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryConstantNormalForceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DryDepthScaledConstantNormalForceFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryDepthScaledConstantNormalForceFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_DryScaleBoxFriction_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::DryScaleBoxFriction>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Dissipation_MechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Dissipation::MechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Dissipation()
%include "openplx/Physics/Interactions/Dissipation/DefaultDissipation.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultFriction.h"
%include "openplx/Physics/Interactions/Dissipation/AsymmetricLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantViscousSurfaceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstraintRelaxationTimeDamping.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConeFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryDepthScaledConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryScaleBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/MechanicalDamping.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_Dissipation()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_Flexibility()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_Flexibility()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Flexibility(prefix)
%rename(prefix ## DefaultFlexibility) openplx::Physics::Interactions::Flexibility::DefaultFlexibility;
%rename(prefix ## LinearElastic) openplx::Physics::Interactions::Flexibility::LinearElastic;
%rename(prefix ## Rigid) openplx::Physics::Interactions::Flexibility::Rigid;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Flexibility()
%shared_ptr(openplx::Physics::Interactions::Flexibility::DefaultFlexibility);
%shared_ptr(openplx::Physics::Interactions::Flexibility::LinearElastic);
%shared_ptr(openplx::Physics::Interactions::Flexibility::Rigid);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Flexibility()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Flexibility()
%template(Physics_Interactions_Flexibility_DefaultFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Flexibility_LinearElastic_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Flexibility_Rigid_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Flexibility::Rigid>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Flexibility()
%include "openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h"
%include "openplx/Physics/Interactions/Flexibility/LinearElastic.h"
%include "openplx/Physics/Interactions/Flexibility/Rigid.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_Flexibility()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_SurfaceContact()
%import "Physics_Interactions_Flexibility.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_SurfaceContact()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_SurfaceContact(prefix)
%rename(prefix ## Model) openplx::Physics::Interactions::SurfaceContact::Model;
%rename(prefix ## PatchElasticity) openplx::Physics::Interactions::SurfaceContact::PatchElasticity;
%rename(prefix ## PointwiseElasticity) openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_SurfaceContact()
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::Model);
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::PatchElasticity);
%shared_ptr(openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_SurfaceContact()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_SurfaceContact()
%template(Physics_Interactions_SurfaceContact_Model_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::Model>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_SurfaceContact_PatchElasticity_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PatchElasticity>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_SurfaceContact_PointwiseElasticity_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::SurfaceContact::PointwiseElasticity>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_SurfaceContact()
%include "openplx/Physics/Interactions/SurfaceContact/Model.h"
%include "openplx/Physics/Interactions/SurfaceContact/PatchElasticity.h"
%include "openplx/Physics/Interactions/SurfaceContact/PointwiseElasticity.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_SurfaceContact()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_SurfaceContact_Traits()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_SurfaceContact_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_SurfaceContact_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Interactions_Toughness()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Interactions_Toughness()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Toughness(prefix)
%rename(prefix ## DefaultToughness) openplx::Physics::Interactions::Toughness::DefaultToughness;
%rename(prefix ## ThresholdFracture) openplx::Physics::Interactions::Toughness::ThresholdFracture;
%rename(prefix ## ThresholdPlastic) openplx::Physics::Interactions::Toughness::ThresholdPlastic;
%rename(prefix ## ThresholdPlasticFracture) openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture;
%rename(prefix ## Unbreakable) openplx::Physics::Interactions::Toughness::Unbreakable;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Toughness()
%shared_ptr(openplx::Physics::Interactions::Toughness::DefaultToughness);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdFracture);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdPlastic);
%shared_ptr(openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture);
%shared_ptr(openplx::Physics::Interactions::Toughness::Unbreakable);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Toughness()
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Toughness()
%template(Physics_Interactions_Toughness_DefaultToughness_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::DefaultToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Toughness_ThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Toughness_ThresholdPlastic_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlastic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Toughness_ThresholdPlasticFracture_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdPlasticFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Interactions_Toughness_Unbreakable_Vector) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Interactions::Toughness::Unbreakable>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Toughness()
%include "openplx/Physics/Interactions/Toughness/DefaultToughness.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdFracture.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlastic.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlasticFracture.h"
%include "openplx/Physics/Interactions/Toughness/Unbreakable.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Interactions_Toughness()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Optics()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Optics()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Optics(prefix)
%rename(prefix ## Material) openplx::Physics::Optics::Material;
%rename(prefix ## WavelengthBand) openplx::Physics::Optics::WavelengthBand;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics()
%shared_ptr(openplx::Physics::Optics::Material);
%shared_ptr(openplx::Physics::Optics::WavelengthBand);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics()
%typemap(out) std::shared_ptr<openplx::Physics::Optics::Material> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Optics::WavelengthBand> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Optics()
%template(Physics_Optics_Material_Vector) std::vector<std::shared_ptr<openplx::Physics::Optics::Material>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Optics::Material>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Optics::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Optics::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Optics::Material>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Optics::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Optics::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Optics_WavelengthBand_Vector) std::vector<std::shared_ptr<openplx::Physics::Optics::WavelengthBand>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Optics::WavelengthBand>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Optics::WavelengthBand>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Optics::WavelengthBand>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Optics::WavelengthBand>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Optics::WavelengthBand>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Optics::WavelengthBand>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Optics()
%include "openplx/Physics/Optics/Material.h"
%include "openplx/Physics/Optics/WavelengthBand.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Optics()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Optics_Surfaces_Traits()
%import "Physics_Optics_Traits.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Optics_Surfaces_Traits()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Optics_Surfaces_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics_Surfaces_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics_Surfaces_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Optics_Surfaces_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Optics_Surfaces_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Optics_Surfaces_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Optics_Traits()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Optics_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Optics_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Optics_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics_Signals()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics_Signals()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics_Signals(prefix)
%rename(prefix ## ActivateInput) openplx::Physics::Signals::ActivateInput;
%rename(prefix ## ActivatedOutput) openplx::Physics::Signals::ActivatedOutput;
%rename(prefix ## AngleInput) openplx::Physics::Signals::AngleInput;
%rename(prefix ## AngleOutput) openplx::Physics::Signals::AngleOutput;
%rename(prefix ## AngularVelocity1DInput) openplx::Physics::Signals::AngularVelocity1DInput;
%rename(prefix ## AngularVelocity1DOutput) openplx::Physics::Signals::AngularVelocity1DOutput;
%rename(prefix ## BoolInput) openplx::Physics::Signals::BoolInput;
%rename(prefix ## BoolInputSignal) openplx::Physics::Signals::BoolInputSignal;
%rename(prefix ## BoolOutput) openplx::Physics::Signals::BoolOutput;
%rename(prefix ## DurationInput) openplx::Physics::Signals::DurationInput;
%rename(prefix ## DurationOutput) openplx::Physics::Signals::DurationOutput;
%rename(prefix ## EnableInteractionInput) openplx::Physics::Signals::EnableInteractionInput;
%rename(prefix ## EngageInput) openplx::Physics::Signals::EngageInput;
%rename(prefix ## EngagedOutput) openplx::Physics::Signals::EngagedOutput;
%rename(prefix ## Force1DInput) openplx::Physics::Signals::Force1DInput;
%rename(prefix ## Force1DOutput) openplx::Physics::Signals::Force1DOutput;
%rename(prefix ## ForceRangeInput) openplx::Physics::Signals::ForceRangeInput;
%rename(prefix ## ForceRangeOutput) openplx::Physics::Signals::ForceRangeOutput;
%rename(prefix ## FractionInput) openplx::Physics::Signals::FractionInput;
%rename(prefix ## FractionOutput) openplx::Physics::Signals::FractionOutput;
%rename(prefix ## Input) openplx::Physics::Signals::Input;
%rename(prefix ## InputOutputType) openplx::Physics::Signals::InputOutputType;
%rename(prefix ## InputSignal) openplx::Physics::Signals::InputSignal;
%rename(prefix ## IntInput) openplx::Physics::Signals::IntInput;
%rename(prefix ## IntInputSignal) openplx::Physics::Signals::IntInputSignal;
%rename(prefix ## IntOutput) openplx::Physics::Signals::IntOutput;
%rename(prefix ## InteractionEnabledOutput) openplx::Physics::Signals::InteractionEnabledOutput;
%rename(prefix ## LinearVelocity1DInput) openplx::Physics::Signals::LinearVelocity1DInput;
%rename(prefix ## LinearVelocity1DOutput) openplx::Physics::Signals::LinearVelocity1DOutput;
%rename(prefix ## Field) openplx::Physics::Signals::Field;
%rename(prefix ## RealField) openplx::Physics::Signals::RealField;
%rename(prefix ## IntField) openplx::Physics::Signals::IntField;
%rename(prefix ## UIntField) openplx::Physics::Signals::UIntField;
%rename(prefix ## BoolField) openplx::Physics::Signals::BoolField;
%rename(prefix ## Marshalling) openplx::Physics::Signals::Marshalling;
%rename(prefix ## MassOutput) openplx::Physics::Signals::MassOutput;
%rename(prefix ## Output) openplx::Physics::Signals::Output;
%rename(prefix ## OutputSignal) openplx::Physics::Signals::OutputSignal;
%rename(prefix ## Position1DInput) openplx::Physics::Signals::Position1DInput;
%rename(prefix ## Position1DOutput) openplx::Physics::Signals::Position1DOutput;
%rename(prefix ## RatioOutput) openplx::Physics::Signals::RatioOutput;
%rename(prefix ## RealInputSignal) openplx::Physics::Signals::RealInputSignal;
%rename(prefix ## RealRangeInputSignal) openplx::Physics::Signals::RealRangeInputSignal;
%rename(prefix ## RelativeVelocity1DOutput) openplx::Physics::Signals::RelativeVelocity1DOutput;
%rename(prefix ## RpmOutput) openplx::Physics::Signals::RpmOutput;
%rename(prefix ## SignalInterface) openplx::Physics::Signals::SignalInterface;
%rename(prefix ## Torque1DInput) openplx::Physics::Signals::Torque1DInput;
%rename(prefix ## Torque1DOutput) openplx::Physics::Signals::Torque1DOutput;
%rename(prefix ## TorqueRangeInput) openplx::Physics::Signals::TorqueRangeInput;
%rename(prefix ## TorqueRangeOutput) openplx::Physics::Signals::TorqueRangeOutput;
%rename(prefix ## Value) openplx::Physics::Signals::Value;
%rename(prefix ## IntValue) openplx::Physics::Signals::IntValue;
%rename(prefix ## BoolValue) openplx::Physics::Signals::BoolValue;
%rename(prefix ## RealValue) openplx::Physics::Signals::RealValue;
%rename(prefix ## AngleValue) openplx::Physics::Signals::AngleValue;
%rename(prefix ## AngularVelocity1DValue) openplx::Physics::Signals::AngularVelocity1DValue;
%rename(prefix ## DistanceValue) openplx::Physics::Signals::DistanceValue;
%rename(prefix ## Force1DValue) openplx::Physics::Signals::Force1DValue;
%rename(prefix ## Velocity1DValue) openplx::Physics::Signals::Velocity1DValue;
%rename(prefix ## Torque1DValue) openplx::Physics::Signals::Torque1DValue;
%rename(prefix ## RpmValue) openplx::Physics::Signals::RpmValue;
%rename(prefix ## FractionValue) openplx::Physics::Signals::FractionValue;
%rename(prefix ## DurationValue) openplx::Physics::Signals::DurationValue;
%rename(prefix ## RatioValue) openplx::Physics::Signals::RatioValue;
%rename(prefix ## MassValue) openplx::Physics::Signals::MassValue;
%rename(prefix ## Vec2Value) openplx::Physics::Signals::Vec2Value;
%rename(prefix ## TorqueRangeValue) openplx::Physics::Signals::TorqueRangeValue;
%rename(prefix ## ForceRangeValue) openplx::Physics::Signals::ForceRangeValue;
%rename(prefix ## Vec3Value) openplx::Physics::Signals::Vec3Value;
%rename(prefix ## Acceleration3DValue) openplx::Physics::Signals::Acceleration3DValue;
%rename(prefix ## AngularAcceleration3DValue) openplx::Physics::Signals::AngularAcceleration3DValue;
%rename(prefix ## AngularVelocity3DValue) openplx::Physics::Signals::AngularVelocity3DValue;
%rename(prefix ## Force3DValue) openplx::Physics::Signals::Force3DValue;
%rename(prefix ## Torque3DValue) openplx::Physics::Signals::Torque3DValue;
%rename(prefix ## Velocity3DValue) openplx::Physics::Signals::Velocity3DValue;
%rename(prefix ## Position3DValue) openplx::Physics::Signals::Position3DValue;
%rename(prefix ## RPYvalue) openplx::Physics::Signals::RPYvalue;
%rename(prefix ## ValueOutputSignal) openplx::Physics::Signals::ValueOutputSignal;
%rename(prefix ## Vec3InputSignal) openplx::Physics::Signals::Vec3InputSignal;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Signals()
%shared_ptr(openplx::Physics::Signals::ActivateInput);
%shared_ptr(openplx::Physics::Signals::ActivatedOutput);
%shared_ptr(openplx::Physics::Signals::AngleInput);
%shared_ptr(openplx::Physics::Signals::AngleOutput);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DInput);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::BoolInput);
%shared_ptr(openplx::Physics::Signals::BoolInputSignal);
%shared_ptr(openplx::Physics::Signals::BoolOutput);
%shared_ptr(openplx::Physics::Signals::DurationInput);
%shared_ptr(openplx::Physics::Signals::DurationOutput);
%shared_ptr(openplx::Physics::Signals::EnableInteractionInput);
%shared_ptr(openplx::Physics::Signals::EngageInput);
%shared_ptr(openplx::Physics::Signals::EngagedOutput);
%shared_ptr(openplx::Physics::Signals::Force1DInput);
%shared_ptr(openplx::Physics::Signals::Force1DOutput);
%shared_ptr(openplx::Physics::Signals::ForceRangeInput);
%shared_ptr(openplx::Physics::Signals::ForceRangeOutput);
%shared_ptr(openplx::Physics::Signals::FractionInput);
%shared_ptr(openplx::Physics::Signals::FractionOutput);
%shared_ptr(openplx::Physics::Signals::Input);
%shared_ptr(openplx::Physics::Signals::InputOutputType);
%shared_ptr(openplx::Physics::Signals::InputSignal);
%shared_ptr(openplx::Physics::Signals::IntInput);
%shared_ptr(openplx::Physics::Signals::IntInputSignal);
%shared_ptr(openplx::Physics::Signals::IntOutput);
%shared_ptr(openplx::Physics::Signals::InteractionEnabledOutput);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DInput);
%shared_ptr(openplx::Physics::Signals::LinearVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::Field);
%shared_ptr(openplx::Physics::Signals::RealField);
%shared_ptr(openplx::Physics::Signals::IntField);
%shared_ptr(openplx::Physics::Signals::UIntField);
%shared_ptr(openplx::Physics::Signals::BoolField);
%shared_ptr(openplx::Physics::Signals::Marshalling);
%shared_ptr(openplx::Physics::Signals::MassOutput);
%shared_ptr(openplx::Physics::Signals::Output);
%shared_ptr(openplx::Physics::Signals::OutputSignal);
%shared_ptr(openplx::Physics::Signals::Position1DInput);
%shared_ptr(openplx::Physics::Signals::Position1DOutput);
%shared_ptr(openplx::Physics::Signals::RatioOutput);
%shared_ptr(openplx::Physics::Signals::RealInputSignal);
%shared_ptr(openplx::Physics::Signals::RealRangeInputSignal);
%shared_ptr(openplx::Physics::Signals::RelativeVelocity1DOutput);
%shared_ptr(openplx::Physics::Signals::RpmOutput);
%shared_ptr(openplx::Physics::Signals::SignalInterface);
%shared_ptr(openplx::Physics::Signals::Torque1DInput);
%shared_ptr(openplx::Physics::Signals::Torque1DOutput);
%shared_ptr(openplx::Physics::Signals::TorqueRangeInput);
%shared_ptr(openplx::Physics::Signals::TorqueRangeOutput);
%shared_ptr(openplx::Physics::Signals::Value);
%shared_ptr(openplx::Physics::Signals::IntValue);
%shared_ptr(openplx::Physics::Signals::BoolValue);
%shared_ptr(openplx::Physics::Signals::RealValue);
%shared_ptr(openplx::Physics::Signals::AngleValue);
%shared_ptr(openplx::Physics::Signals::AngularVelocity1DValue);
%shared_ptr(openplx::Physics::Signals::DistanceValue);
%shared_ptr(openplx::Physics::Signals::Force1DValue);
%shared_ptr(openplx::Physics::Signals::Velocity1DValue);
%shared_ptr(openplx::Physics::Signals::Torque1DValue);
%shared_ptr(openplx::Physics::Signals::RpmValue);
%shared_ptr(openplx::Physics::Signals::FractionValue);
%shared_ptr(openplx::Physics::Signals::DurationValue);
%shared_ptr(openplx::Physics::Signals::RatioValue);
%shared_ptr(openplx::Physics::Signals::MassValue);
%shared_ptr(openplx::Physics::Signals::Vec2Value);
%shared_ptr(openplx::Physics::Signals::TorqueRangeValue);
%shared_ptr(openplx::Physics::Signals::ForceRangeValue);
%shared_ptr(openplx::Physics::Signals::Vec3Value);
%shared_ptr(openplx::Physics::Signals::Acceleration3DValue);
%shared_ptr(openplx::Physics::Signals::AngularAcceleration3DValue);
%shared_ptr(openplx::Physics::Signals::AngularVelocity3DValue);
%shared_ptr(openplx::Physics::Signals::Force3DValue);
%shared_ptr(openplx::Physics::Signals::Torque3DValue);
%shared_ptr(openplx::Physics::Signals::Velocity3DValue);
%shared_ptr(openplx::Physics::Signals::Position3DValue);
%shared_ptr(openplx::Physics::Signals::RPYvalue);
%shared_ptr(openplx::Physics::Signals::ValueOutputSignal);
%shared_ptr(openplx::Physics::Signals::Vec3InputSignal);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Signals()
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ActivateInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ActivatedOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngleInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngleOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::BoolInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::BoolInputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::BoolOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::DurationInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::DurationOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::EngageInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::EngagedOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Force1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Force1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ForceRangeInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::FractionInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::FractionOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Input> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::InputOutputType> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::InputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::IntInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::IntInputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::IntOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Field> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RealField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::IntField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::UIntField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::BoolField> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Marshalling> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::MassOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Output> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::OutputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Position1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Position1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RatioOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RealInputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RpmOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::SignalInterface> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Torque1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Value> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::IntValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::BoolValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RealValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngleValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::DistanceValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Force1DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Velocity1DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Torque1DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RpmValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::FractionValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::DurationValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RatioValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::MassValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Vec2Value> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ForceRangeValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Vec3Value> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Force3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Torque3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Velocity3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Position3DValue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::RPYvalue> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics_Signals()
%template(Physics_Signals_ActivateInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivateInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ActivateInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ActivateInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ActivateInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivateInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ActivateInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ActivateInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_ActivatedOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ActivatedOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngleInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngleInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngleInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngleInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngleOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngleOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngleOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngleOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngularVelocity1DInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngularVelocity1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_BoolInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::BoolInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::BoolInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_BoolInputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_BoolOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::BoolOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::BoolOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::BoolOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_DurationInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::DurationInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::DurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::DurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_DurationOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::DurationOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::DurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::DurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_EnableInteractionInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EnableInteractionInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_EngageInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::EngageInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::EngageInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::EngageInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EngageInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::EngageInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::EngageInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EngageInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_EngagedOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::EngagedOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::EngagedOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::EngagedOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EngagedOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::EngagedOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::EngagedOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::EngagedOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Force1DInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Force1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_ForceRangeInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_ForceRangeOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_FractionInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::FractionInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::FractionInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::FractionInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_FractionOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::FractionOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::FractionOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::FractionOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Input_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Input>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Input>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Input>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Input>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Input>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Input>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Input>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_InputOutputType_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::InputOutputType>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::InputOutputType>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::InputOutputType>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InputOutputType>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::InputOutputType>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::InputOutputType>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InputOutputType>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_InputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::InputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::InputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::InputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::InputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::InputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_IntInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::IntInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::IntInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::IntInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_IntInputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::IntInputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::IntInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::IntInputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::IntInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_IntOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::IntOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::IntOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::IntOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::IntOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_InteractionEnabledOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::InteractionEnabledOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_LinearVelocity1DInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_LinearVelocity1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::LinearVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Field_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Field>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Field>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Field>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Field>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Field>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Field>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Field>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RealField_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RealField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RealField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RealField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RealField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_IntField_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::IntField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::IntField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::IntField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::IntField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_UIntField_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::UIntField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::UIntField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::UIntField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::UIntField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::UIntField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::UIntField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::UIntField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_BoolField_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolField>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::BoolField>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::BoolField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolField>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::BoolField>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolField>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Marshalling_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Marshalling>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Marshalling>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Marshalling>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Marshalling>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Marshalling>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Marshalling>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Marshalling>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_MassOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::MassOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::MassOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::MassOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::MassOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::MassOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::MassOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::MassOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Output_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Output>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Output>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Output>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Output>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Output>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Output>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_OutputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::OutputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::OutputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::OutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::OutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::OutputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::OutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::OutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Position1DInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Position1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Position1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Position1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Position1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Position1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Position1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RatioOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RatioOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RatioOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RatioOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RatioOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RatioOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RatioOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RatioOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RealInputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealInputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RealInputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RealInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RealInputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RealInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RealRangeInputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealRangeInputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RelativeVelocity1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RpmOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RpmOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RpmOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RpmOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RpmOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RpmOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RpmOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RpmOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_SignalInterface_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::SignalInterface>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::SignalInterface>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::SignalInterface>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::SignalInterface>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::SignalInterface>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::SignalInterface>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::SignalInterface>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Torque1DInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Torque1DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_TorqueRangeInput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_TorqueRangeOutput_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Value_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Value>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Value>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_IntValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::IntValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::IntValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::IntValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::IntValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::IntValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::IntValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_BoolValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::BoolValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::BoolValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::BoolValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::BoolValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::BoolValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RealValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RealValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RealValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RealValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RealValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngleValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngleValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngleValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngleValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngleValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngleValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngularVelocity1DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_DistanceValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::DistanceValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::DistanceValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::DistanceValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DistanceValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::DistanceValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::DistanceValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DistanceValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Force1DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Force1DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Force1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Velocity1DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Velocity1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Torque1DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque1DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Torque1DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque1DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RpmValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RpmValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RpmValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RpmValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RpmValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RpmValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RpmValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RpmValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_FractionValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::FractionValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::FractionValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::FractionValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::FractionValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::FractionValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_DurationValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::DurationValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::DurationValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::DurationValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::DurationValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::DurationValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RatioValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RatioValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RatioValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RatioValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RatioValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RatioValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RatioValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RatioValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_MassValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::MassValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::MassValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::MassValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::MassValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::MassValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::MassValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::MassValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Vec2Value_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec2Value>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Vec2Value>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Vec2Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec2Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec2Value>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Vec2Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec2Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_TorqueRangeValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::TorqueRangeValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_ForceRangeValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ForceRangeValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Vec3Value_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3Value>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3Value>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Vec3Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec3Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3Value>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Vec3Value>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec3Value>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Acceleration3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Acceleration3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngularAcceleration3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularAcceleration3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_AngularVelocity3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::AngularVelocity3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Force3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Force3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Force3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Force3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Force3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Force3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Force3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Torque3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Torque3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Torque3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Torque3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Torque3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Torque3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Velocity3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Velocity3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Position3DValue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Position3DValue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Position3DValue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Position3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Position3DValue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Position3DValue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Position3DValue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_RPYvalue_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::RPYvalue>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::RPYvalue>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::RPYvalue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RPYvalue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::RPYvalue>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::RPYvalue>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::RPYvalue>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_ValueOutputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics_Signals_Vec3InputSignal_Vector) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics::Signals::Vec3InputSignal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics_Signals()
%include "openplx/Physics/Signals/Input.h"
%include "openplx/Physics/Signals/BoolInput.h"
%include "openplx/Physics/Signals/ActivateInput.h"
%include "openplx/Physics/Signals/Output.h"
%include "openplx/Physics/Signals/BoolOutput.h"
%include "openplx/Physics/Signals/ActivatedOutput.h"
%include "openplx/Physics/Signals/AngleInput.h"
%include "openplx/Physics/Signals/AngleOutput.h"
%include "openplx/Physics/Signals/AngularVelocity1DInput.h"
%include "openplx/Physics/Signals/AngularVelocity1DOutput.h"
%include "openplx/Physics/Signals/InputSignal.h"
%include "openplx/Physics/Signals/BoolInputSignal.h"
%include "openplx/Physics/Signals/DurationInput.h"
%include "openplx/Physics/Signals/DurationOutput.h"
%include "openplx/Physics/Signals/EnableInteractionInput.h"
%include "openplx/Physics/Signals/EngageInput.h"
%include "openplx/Physics/Signals/EngagedOutput.h"
%include "openplx/Physics/Signals/Force1DInput.h"
%include "openplx/Physics/Signals/Force1DOutput.h"
%include "openplx/Physics/Signals/ForceRangeInput.h"
%include "openplx/Physics/Signals/ForceRangeOutput.h"
%include "openplx/Physics/Signals/FractionInput.h"
%include "openplx/Physics/Signals/FractionOutput.h"
%include "openplx/Physics/Signals/InputOutputType.h"
%include "openplx/Physics/Signals/IntInput.h"
%include "openplx/Physics/Signals/IntInputSignal.h"
%include "openplx/Physics/Signals/IntOutput.h"
%include "openplx/Physics/Signals/InteractionEnabledOutput.h"
%include "openplx/Physics/Signals/LinearVelocity1DInput.h"
%include "openplx/Physics/Signals/LinearVelocity1DOutput.h"
%include "openplx/Physics/Signals/Field.h"
%include "openplx/Physics/Signals/RealField.h"
%include "openplx/Physics/Signals/IntField.h"
%include "openplx/Physics/Signals/UIntField.h"
%include "openplx/Physics/Signals/BoolField.h"
%include "openplx/Physics/Signals/Marshalling.h"
%include "openplx/Physics/Signals/MassOutput.h"
%include "openplx/Physics/Signals/OutputSignal.h"
%include "openplx/Physics/Signals/Position1DInput.h"
%include "openplx/Physics/Signals/Position1DOutput.h"
%include "openplx/Physics/Signals/RatioOutput.h"
%include "openplx/Physics/Signals/RealInputSignal.h"
%include "openplx/Physics/Signals/RealRangeInputSignal.h"
%include "openplx/Physics/Signals/RelativeVelocity1DOutput.h"
%include "openplx/Physics/Signals/RpmOutput.h"
%include "openplx/Physics/Signals/SignalInterface.h"
%include "openplx/Physics/Signals/Torque1DInput.h"
%include "openplx/Physics/Signals/Torque1DOutput.h"
%include "openplx/Physics/Signals/TorqueRangeInput.h"
%include "openplx/Physics/Signals/TorqueRangeOutput.h"
%include "openplx/Physics/Signals/Value.h"
%include "openplx/Physics/Signals/IntValue.h"
%include "openplx/Physics/Signals/BoolValue.h"
%include "openplx/Physics/Signals/RealValue.h"
%include "openplx/Physics/Signals/AngleValue.h"
%include "openplx/Physics/Signals/AngularVelocity1DValue.h"
%include "openplx/Physics/Signals/DistanceValue.h"
%include "openplx/Physics/Signals/Force1DValue.h"
%include "openplx/Physics/Signals/Velocity1DValue.h"
%include "openplx/Physics/Signals/Torque1DValue.h"
%include "openplx/Physics/Signals/RpmValue.h"
%include "openplx/Physics/Signals/FractionValue.h"
%include "openplx/Physics/Signals/DurationValue.h"
%include "openplx/Physics/Signals/RatioValue.h"
%include "openplx/Physics/Signals/MassValue.h"
%include "openplx/Physics/Signals/Vec2Value.h"
%include "openplx/Physics/Signals/TorqueRangeValue.h"
%include "openplx/Physics/Signals/ForceRangeValue.h"
%include "openplx/Physics/Signals/Vec3Value.h"
%include "openplx/Physics/Signals/Acceleration3DValue.h"
%include "openplx/Physics/Signals/AngularAcceleration3DValue.h"
%include "openplx/Physics/Signals/AngularVelocity3DValue.h"
%include "openplx/Physics/Signals/Force3DValue.h"
%include "openplx/Physics/Signals/Torque3DValue.h"
%include "openplx/Physics/Signals/Velocity3DValue.h"
%include "openplx/Physics/Signals/Position3DValue.h"
%include "openplx/Physics/Signals/RPYvalue.h"
%include "openplx/Physics/Signals/ValueOutputSignal.h"
%include "openplx/Physics/Signals/Vec3InputSignal.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics_Signals()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Physics()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Physics()
%import "Physics.i"
%import "Physics_Bodies.i"
%import "Physics_Geometries.i"
%import "Physics_Interactions.i"
%import "Physics_Interactions_Adhesion.i"
%import "Physics_Interactions_Clearance.i"
%import "Physics_Interactions_Dissipation.i"
%import "Physics_Interactions_Flexibility.i"
%import "Physics_Interactions_SurfaceContact.i"
%import "Physics_Interactions_SurfaceContact_Traits.i"
%import "Physics_Interactions_Toughness.i"
%import "Physics_Optics.i"
%import "Physics_Optics_Surfaces_Traits.i"
%import "Physics_Optics_Traits.i"
%import "Physics_Signals.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Physics()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Physics()
%import "Math.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Physics(prefix)
OPENPLX_SWIG_NS_RENAMES_Physics(prefix);
OPENPLX_SWIG_NS_RENAMES_Physics_Bodies(prefix ## Bodies_);
OPENPLX_SWIG_NS_RENAMES_Physics_Geometries(prefix ## Geometries_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions(prefix ## Interactions_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Adhesion(prefix ## Interactions_Adhesion_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Clearance(prefix ## Interactions_Clearance_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Dissipation(prefix ## Interactions_Dissipation_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Flexibility(prefix ## Interactions_Flexibility_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_SurfaceContact(prefix ## Interactions_SurfaceContact_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_SurfaceContact_Traits(prefix ## Interactions_SurfaceContact_Traits_);
OPENPLX_SWIG_NS_RENAMES_Physics_Interactions_Toughness(prefix ## Interactions_Toughness_);
OPENPLX_SWIG_NS_RENAMES_Physics_Optics(prefix ## Optics_);
OPENPLX_SWIG_NS_RENAMES_Physics_Optics_Surfaces_Traits(prefix ## Optics_Surfaces_Traits_);
OPENPLX_SWIG_NS_RENAMES_Physics_Optics_Traits(prefix ## Optics_Traits_);
OPENPLX_SWIG_NS_RENAMES_Physics_Signals(prefix ## Signals_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics()
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Adhesion();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Clearance();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Flexibility();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Interactions_Toughness();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics_Surfaces_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Optics_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Adhesion();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Clearance();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Flexibility();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Interactions_Toughness();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics_Surfaces_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Optics_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Physics()
OPENPLX_SWIG_NS_VECTORS_Physics();
OPENPLX_SWIG_NS_VECTORS_Physics_Bodies();
OPENPLX_SWIG_NS_VECTORS_Physics_Geometries();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Adhesion();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Clearance();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Dissipation();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Flexibility();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_VECTORS_Physics_Interactions_Toughness();
OPENPLX_SWIG_NS_VECTORS_Physics_Optics();
OPENPLX_SWIG_NS_VECTORS_Physics_Optics_Surfaces_Traits();
OPENPLX_SWIG_NS_VECTORS_Physics_Optics_Traits();
OPENPLX_SWIG_NS_VECTORS_Physics_Signals();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Physics()
OPENPLX_SWIG_NS_INCLUDES_Physics();
OPENPLX_SWIG_NS_INCLUDES_Physics_Bodies();
OPENPLX_SWIG_NS_INCLUDES_Physics_Geometries();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Adhesion();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Clearance();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Dissipation();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Flexibility();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_INCLUDES_Physics_Interactions_Toughness();
OPENPLX_SWIG_NS_INCLUDES_Physics_Optics();
OPENPLX_SWIG_NS_INCLUDES_Physics_Optics_Surfaces_Traits();
OPENPLX_SWIG_NS_INCLUDES_Physics_Optics_Traits();
OPENPLX_SWIG_NS_INCLUDES_Physics_Signals();
%enddef

