%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_DriveTrain()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_DriveTrain()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_DriveTrain(prefix)
%rename(prefix ## Actuator) openplx::DriveTrain::Actuator;
%rename(prefix ## AutomaticBrake) openplx::DriveTrain::AutomaticBrake;
%rename(prefix ## AutomaticClutch) openplx::DriveTrain::AutomaticClutch;
%rename(prefix ## Differential) openplx::DriveTrain::Differential;
%rename(prefix ## EmpiricalEngine) openplx::DriveTrain::EmpiricalEngine;
%rename(prefix ## RPMTorquePair) openplx::DriveTrain::RPMTorquePair;
%rename(prefix ## VelocityRatioTorqueMultiplicationPair) openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair;
%rename(prefix ## VelocityRatioGeometryFactorPair) openplx::DriveTrain::VelocityRatioGeometryFactorPair;
%rename(prefix ## EmpiricalTorqueConverter) openplx::DriveTrain::EmpiricalTorqueConverter;
%rename(prefix ## FlexibleGear) openplx::DriveTrain::FlexibleGear;
%rename(prefix ## Gear) openplx::DriveTrain::Gear;
%rename(prefix ## GearBox) openplx::DriveTrain::GearBox;
%rename(prefix ## HingeActuator) openplx::DriveTrain::HingeActuator;
%rename(prefix ## InfinitePowerSource) openplx::DriveTrain::InfinitePowerSource;
%rename(prefix ## ManualBrake) openplx::DriveTrain::ManualBrake;
%rename(prefix ## ManualClutch) openplx::DriveTrain::ManualClutch;
%rename(prefix ## MeanValueEngine) openplx::DriveTrain::MeanValueEngine;
%rename(prefix ## PowerSource) openplx::DriveTrain::PowerSource;
%rename(prefix ## PrismaticActuator) openplx::DriveTrain::PrismaticActuator;
%rename(prefix ## Shaft) openplx::DriveTrain::Shaft;
%rename(prefix ## TorqueLimitedSlipDifferential) openplx::DriveTrain::TorqueLimitedSlipDifferential;
%rename(prefix ## TorqueMotor) openplx::DriveTrain::TorqueMotor;
%rename(prefix ## ViscousGear) openplx::DriveTrain::ViscousGear;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain()
%shared_ptr(openplx::DriveTrain::Actuator);
%shared_ptr(openplx::DriveTrain::AutomaticBrake);
%shared_ptr(openplx::DriveTrain::AutomaticClutch);
%shared_ptr(openplx::DriveTrain::Differential);
%shared_ptr(openplx::DriveTrain::EmpiricalEngine);
%shared_ptr(openplx::DriveTrain::RPMTorquePair);
%shared_ptr(openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair);
%shared_ptr(openplx::DriveTrain::VelocityRatioGeometryFactorPair);
%shared_ptr(openplx::DriveTrain::EmpiricalTorqueConverter);
%shared_ptr(openplx::DriveTrain::FlexibleGear);
%shared_ptr(openplx::DriveTrain::Gear);
%shared_ptr(openplx::DriveTrain::GearBox);
%shared_ptr(openplx::DriveTrain::HingeActuator);
%shared_ptr(openplx::DriveTrain::InfinitePowerSource);
%shared_ptr(openplx::DriveTrain::ManualBrake);
%shared_ptr(openplx::DriveTrain::ManualClutch);
%shared_ptr(openplx::DriveTrain::MeanValueEngine);
%shared_ptr(openplx::DriveTrain::PowerSource);
%shared_ptr(openplx::DriveTrain::PrismaticActuator);
%shared_ptr(openplx::DriveTrain::Shaft);
%shared_ptr(openplx::DriveTrain::TorqueLimitedSlipDifferential);
%shared_ptr(openplx::DriveTrain::TorqueMotor);
%shared_ptr(openplx::DriveTrain::ViscousGear);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain()
%typemap(out) std::shared_ptr<openplx::DriveTrain::Actuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::AutomaticBrake> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::AutomaticClutch> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Differential> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::EmpiricalEngine> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::RPMTorquePair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::FlexibleGear> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Gear> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::GearBox> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::HingeActuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::InfinitePowerSource> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::ManualBrake> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::ManualClutch> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::MeanValueEngine> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::PowerSource> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::PrismaticActuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Shaft> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::TorqueMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::ViscousGear> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_DriveTrain()
%template(DriveTrain_Actuator_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Actuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Actuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Actuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_AutomaticBrake_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticBrake>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticBrake>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::AutomaticBrake>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::AutomaticBrake>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticBrake>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::AutomaticBrake>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::AutomaticBrake>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_AutomaticClutch_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticClutch>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticClutch>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::AutomaticClutch>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::AutomaticClutch>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::AutomaticClutch>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::AutomaticClutch>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::AutomaticClutch>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Differential_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Differential>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Differential>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Differential>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Differential>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Differential>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Differential>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Differential>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_EmpiricalEngine_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::EmpiricalEngine>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_RPMTorquePair_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::RPMTorquePair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::RPMTorquePair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::RPMTorquePair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::RPMTorquePair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::RPMTorquePair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_VelocityRatioTorqueMultiplicationPair_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_VelocityRatioGeometryFactorPair_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_EmpiricalTorqueConverter_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::EmpiricalTorqueConverter>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_FlexibleGear_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::FlexibleGear>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::FlexibleGear>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::FlexibleGear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::FlexibleGear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::FlexibleGear>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::FlexibleGear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::FlexibleGear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Gear_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Gear>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Gear>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Gear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Gear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Gear>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Gear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Gear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_GearBox_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::GearBox>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::GearBox>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::GearBox>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::GearBox>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::GearBox>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::GearBox>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::GearBox>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_HingeActuator_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::HingeActuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::HingeActuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::HingeActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::HingeActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::HingeActuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::HingeActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::HingeActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_InfinitePowerSource_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::InfinitePowerSource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_ManualBrake_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualBrake>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::ManualBrake>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::ManualBrake>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ManualBrake>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::ManualBrake>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::ManualBrake>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ManualBrake>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_ManualClutch_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::ManualClutch>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::ManualClutch>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::ManualClutch>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ManualClutch>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::ManualClutch>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::ManualClutch>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ManualClutch>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_MeanValueEngine_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::MeanValueEngine>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::MeanValueEngine>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::MeanValueEngine>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::MeanValueEngine>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::MeanValueEngine>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::MeanValueEngine>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::MeanValueEngine>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_PowerSource_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::PowerSource>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::PowerSource>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::PowerSource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::PowerSource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::PowerSource>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::PowerSource>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::PowerSource>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_PrismaticActuator_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::PrismaticActuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::PrismaticActuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::PrismaticActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::PrismaticActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::PrismaticActuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::PrismaticActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::PrismaticActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Shaft_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Shaft>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Shaft>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Shaft>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Shaft>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Shaft>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Shaft>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Shaft>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_TorqueLimitedSlipDifferential_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::TorqueLimitedSlipDifferential>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_TorqueMotor_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::TorqueMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::TorqueMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::TorqueMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::TorqueMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::TorqueMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::TorqueMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_ViscousGear_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::ViscousGear>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::ViscousGear>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::ViscousGear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ViscousGear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::ViscousGear>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::ViscousGear>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::ViscousGear>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_DriveTrain()
%include "openplx/DriveTrain/Actuator.h"
%include "openplx/DriveTrain/ManualBrake.h"
%include "openplx/DriveTrain/AutomaticBrake.h"
%include "openplx/DriveTrain/ManualClutch.h"
%include "openplx/DriveTrain/AutomaticClutch.h"
%include "openplx/DriveTrain/Differential.h"
%include "openplx/DriveTrain/EmpiricalEngine.h"
%include "openplx/DriveTrain/RPMTorquePair.h"
%include "openplx/DriveTrain/VelocityRatioTorqueMultiplicationPair.h"
%include "openplx/DriveTrain/VelocityRatioGeometryFactorPair.h"
%include "openplx/DriveTrain/EmpiricalTorqueConverter.h"
%include "openplx/DriveTrain/Gear.h"
%include "openplx/DriveTrain/FlexibleGear.h"
%include "openplx/DriveTrain/GearBox.h"
%include "openplx/DriveTrain/HingeActuator.h"
%include "openplx/DriveTrain/PowerSource.h"
%include "openplx/DriveTrain/InfinitePowerSource.h"
%include "openplx/DriveTrain/MeanValueEngine.h"
%include "openplx/DriveTrain/PrismaticActuator.h"
%include "openplx/DriveTrain/Shaft.h"
%include "openplx/DriveTrain/TorqueLimitedSlipDifferential.h"
%include "openplx/DriveTrain/TorqueMotor.h"
%include "openplx/DriveTrain/ViscousGear.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_DriveTrain()
%pythoncode %{
from . import Engines
from . import MechanicalDriveTrains
from . import Signals
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_DriveTrain_Engines()
%import "DriveTrain.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_DriveTrain_Engines()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_DriveTrain_Engines(prefix)
%rename(prefix ## CatC17520) openplx::DriveTrain::Engines::CatC17520;
%rename(prefix ## CatC27) openplx::DriveTrain::Engines::CatC27;
%rename(prefix ## CatC32ACERT) openplx::DriveTrain::Engines::CatC32ACERT;
%rename(prefix ## DoosanDE08TIS) openplx::DriveTrain::Engines::DoosanDE08TIS;
%rename(prefix ## GMTruck) openplx::DriveTrain::Engines::GMTruck;
%rename(prefix ## JohnDeere6068HF485) openplx::DriveTrain::Engines::JohnDeere6068HF485;
%rename(prefix ## KomatsuWA47510) openplx::DriveTrain::Engines::KomatsuWA47510;
%rename(prefix ## SaabB234i) openplx::DriveTrain::Engines::SaabB234i;
%rename(prefix ## ScaniaK310UB4X2Euro5) openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5;
%rename(prefix ## VolvoBMTD45B) openplx::DriveTrain::Engines::VolvoBMTD45B;
%rename(prefix ## VolvoD16E540) openplx::DriveTrain::Engines::VolvoD16E540;
%rename(prefix ## VolvoT5) openplx::DriveTrain::Engines::VolvoT5;
%rename(prefix ## VolvoTD73KD) openplx::DriveTrain::Engines::VolvoTD73KD;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Engines()
%shared_ptr(openplx::DriveTrain::Engines::CatC17520);
%shared_ptr(openplx::DriveTrain::Engines::CatC27);
%shared_ptr(openplx::DriveTrain::Engines::CatC32ACERT);
%shared_ptr(openplx::DriveTrain::Engines::DoosanDE08TIS);
%shared_ptr(openplx::DriveTrain::Engines::GMTruck);
%shared_ptr(openplx::DriveTrain::Engines::JohnDeere6068HF485);
%shared_ptr(openplx::DriveTrain::Engines::KomatsuWA47510);
%shared_ptr(openplx::DriveTrain::Engines::SaabB234i);
%shared_ptr(openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5);
%shared_ptr(openplx::DriveTrain::Engines::VolvoBMTD45B);
%shared_ptr(openplx::DriveTrain::Engines::VolvoD16E540);
%shared_ptr(openplx::DriveTrain::Engines::VolvoT5);
%shared_ptr(openplx::DriveTrain::Engines::VolvoTD73KD);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Engines()
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::CatC17520> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::CatC27> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::GMTruck> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_DriveTrain_Engines()
%template(DriveTrain_Engines_CatC17520_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC17520>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_CatC27_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC27>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC27>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC27>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC27>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC27>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC27>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC27>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_CatC32ACERT_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::CatC32ACERT>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_DoosanDE08TIS_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::DoosanDE08TIS>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_GMTruck_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::GMTruck>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_JohnDeere6068HF485_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::JohnDeere6068HF485>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_KomatsuWA47510_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::KomatsuWA47510>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_SaabB234i_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::SaabB234i>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_ScaniaK310UB4X2Euro5_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::ScaniaK310UB4X2Euro5>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_VolvoBMTD45B_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoBMTD45B>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_VolvoD16E540_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoD16E540>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_VolvoT5_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoT5>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Engines_VolvoTD73KD_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Engines::VolvoTD73KD>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Engines()
%include "openplx/DriveTrain/Engines/CatC17520.h"
%include "openplx/DriveTrain/Engines/CatC27.h"
%include "openplx/DriveTrain/Engines/CatC32ACERT.h"
%include "openplx/DriveTrain/Engines/DoosanDE08TIS.h"
%include "openplx/DriveTrain/Engines/GMTruck.h"
%include "openplx/DriveTrain/Engines/JohnDeere6068HF485.h"
%include "openplx/DriveTrain/Engines/KomatsuWA47510.h"
%include "openplx/DriveTrain/Engines/SaabB234i.h"
%include "openplx/DriveTrain/Engines/ScaniaK310UB4X2Euro5.h"
%include "openplx/DriveTrain/Engines/VolvoBMTD45B.h"
%include "openplx/DriveTrain/Engines/VolvoD16E540.h"
%include "openplx/DriveTrain/Engines/VolvoT5.h"
%include "openplx/DriveTrain/Engines/VolvoTD73KD.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_DriveTrain_Engines()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_DriveTrain_MechanicalDriveTrains()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_DriveTrain_MechanicalDriveTrains()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_DriveTrain_MechanicalDriveTrains(prefix)
%rename(prefix ## TwoWheelTemplate) openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_MechanicalDriveTrains()
%shared_ptr(openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_MechanicalDriveTrains()
%typemap(out) std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_DriveTrain_MechanicalDriveTrains()
%template(DriveTrain_MechanicalDriveTrains_TwoWheelTemplate_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::MechanicalDriveTrains::TwoWheelTemplate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_DriveTrain_MechanicalDriveTrains()
%include "openplx/DriveTrain/MechanicalDriveTrains/TwoWheelTemplate.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_DriveTrain_MechanicalDriveTrains()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_DriveTrain_Signals()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_DriveTrain_Signals()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_DriveTrain_Signals(prefix)
%rename(prefix ## AutomaticClutchDisengagementDurationInput) openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput;
%rename(prefix ## AutomaticClutchDisengagementDurationOutput) openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput;
%rename(prefix ## AutomaticClutchEngagementDurationInput) openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput;
%rename(prefix ## AutomaticClutchEngagementDurationOutput) openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput;
%rename(prefix ## TorqueConverterLockUpInput) openplx::DriveTrain::Signals::TorqueConverterLockUpInput;
%rename(prefix ## TorqueConverterLockedUpOutput) openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput;
%rename(prefix ## TorqueConverterPumpTorqueOutput) openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput;
%rename(prefix ## TorqueConverterTurbineTorqueOutput) openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Signals()
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput);
%shared_ptr(openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockUpInput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput);
%shared_ptr(openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Signals()
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_DriveTrain_Signals()
%template(DriveTrain_Signals_AutomaticClutchDisengagementDurationInput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_AutomaticClutchDisengagementDurationOutput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_AutomaticClutchEngagementDurationInput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_AutomaticClutchEngagementDurationOutput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_TorqueConverterLockUpInput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_TorqueConverterLockedUpOutput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_TorqueConverterPumpTorqueOutput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterPumpTorqueOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(DriveTrain_Signals_TorqueConverterTurbineTorqueOutput_Vector) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterTurbineTorqueOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Signals()
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationInput.h"
%include "openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockUpInput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterLockedUpOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterPumpTorqueOutput.h"
%include "openplx/DriveTrain/Signals/TorqueConverterTurbineTorqueOutput.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_DriveTrain_Signals()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_DriveTrain_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_DriveTrain_Traits()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_DriveTrain_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_DriveTrain_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_DriveTrain_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_DriveTrain()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain()
%import "DriveTrain.i"
%import "DriveTrain_Engines.i"
%import "DriveTrain_MechanicalDriveTrains.i"
%import "DriveTrain_Signals.i"
%import "DriveTrain_Traits.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_DriveTrain()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_DriveTrain()
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_DriveTrain(prefix)
OPENPLX_SWIG_NS_RENAMES_DriveTrain(prefix);
OPENPLX_SWIG_NS_RENAMES_DriveTrain_Engines(prefix ## Engines_);
OPENPLX_SWIG_NS_RENAMES_DriveTrain_MechanicalDriveTrains(prefix ## MechanicalDriveTrains_);
OPENPLX_SWIG_NS_RENAMES_DriveTrain_Signals(prefix ## Signals_);
OPENPLX_SWIG_NS_RENAMES_DriveTrain_Traits(prefix ## Traits_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_DriveTrain()
OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain();
OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Engines();
OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_MechanicalDriveTrains();
OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Signals();
OPENPLX_SWIG_NS_SHARED_POINTERS_DriveTrain_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_DriveTrain()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Engines();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_MechanicalDriveTrains();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Signals();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_DriveTrain_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_DriveTrain()
OPENPLX_SWIG_NS_VECTORS_DriveTrain();
OPENPLX_SWIG_NS_VECTORS_DriveTrain_Engines();
OPENPLX_SWIG_NS_VECTORS_DriveTrain_MechanicalDriveTrains();
OPENPLX_SWIG_NS_VECTORS_DriveTrain_Signals();
OPENPLX_SWIG_NS_VECTORS_DriveTrain_Traits();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_DriveTrain()
OPENPLX_SWIG_NS_INCLUDES_DriveTrain();
OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Engines();
OPENPLX_SWIG_NS_INCLUDES_DriveTrain_MechanicalDriveTrains();
OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Signals();
OPENPLX_SWIG_NS_INCLUDES_DriveTrain_Traits();
%enddef

