#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Visuals/VisualsBundleExport.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Visuals/Materials/Material.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TextureMaterial */
namespace openplx::Visuals::Materials {
    /**
     * Can be used to add a texture to an Visuals.Geometries.ExternalTriMeshGeometry.
     *
     * Note: It currently only works for .obj files that include texture coordinates.
     **/
    class OPENPLX_Visuals_BUNDLE_EXPORT TextureMaterial : public openplx::Visuals::Materials::Material {
        protected:
            std::string m_path;
            bool m_repeat;
            double m_scale_u;
            double m_scale_v;

        public:
            TextureMaterial();
            virtual ~TextureMaterial();
            std::string path() const;
            bool repeat() const;
            double scale_u() const;
            double scale_v() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
