#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Visuals/VisualsBundleExport.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Math/AffineTransform.h>
#include <openplx/Visuals/Materials/Material.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Geometry */
namespace openplx::Visuals::Geometries {
    class OPENPLX_Visuals_BUNDLE_EXPORT Geometry : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Math::AffineTransform> m_local_transform;
            std::shared_ptr<openplx::Visuals::Materials::Material> m_material;

        public:
            Geometry();
            virtual ~Geometry();
            std::shared_ptr<openplx::Math::AffineTransform> local_transform() const;
            std::shared_ptr<openplx::Visuals::Materials::Material> material() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
