#pragma once

#include <memory>
#include "UuidGenerator.h"
#include "openplx/ErrorReporter.h"

namespace openplx
{
    class RuntimeContext
    {
        public:
            RuntimeContext(std::shared_ptr<ErrorReporter> error_reporter);

            std::shared_ptr<ErrorReporter> getErrorReporter() const;
            void useUuidv5(std::string namespace_id);

            const UuidSettings& getUuidSettings() const;
        private:
            UuidSettings m_uuid_settings;
            std::shared_ptr<ErrorReporter> m_error_reporter;
    };
}
