#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Robots/Robot.h>
#include <openplx/Robotics/Robots/SerialManipulatorData.h>
#include <openplx/Robotics/Links/RigidLink.h>
#include <openplx/Robotics/Joints/HingeJoint.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SixAxisSerialManipulator */
namespace openplx::Robotics::Robots {
    class OPENPLX_Robotics_BUNDLE_EXPORT SixAxisSerialManipulator : public openplx::Robotics::Robots::Robot {
        protected:
            std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData> m_data;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link1;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link2;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link3;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link4;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link5;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> m_link6;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint1;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint2;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint3;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint4;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint5;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> m_joint6;

        public:
            SixAxisSerialManipulator();
            virtual ~SixAxisSerialManipulator();
            std::shared_ptr<openplx::Robotics::Robots::SerialManipulatorData> data() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link1() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link2() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link3() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link4() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link5() const;
            std::shared_ptr<openplx::Robotics::Links::RigidLink> link6() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint1() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint2() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint3() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint4() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint5() const;
            std::shared_ptr<openplx::Robotics::Joints::HingeJoint> joint6() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
