#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model OrientedFriction */
namespace openplx::Physics3D::Interactions::SurfaceContact::Traits {
    /**
     *     The OrientedFrictionTrait is designed to model non-isotropic surface friction,
     *     meaning it allows for different frictional properties depending on direction.
     *     This trait modifies the friction model based on a specified primary_direction,
     *     making it adaptable to surfaces where directional friction is a factor.
     *     It is compatible with any DryFriction implementation that inherits from DefaultDryFriction.
     *     The friction in the primary_direction is determined by the coefficient from the DryFriction model,
     *     while the secondary_coefficient defines the friction in a secondary direction.
     *     This secondary direction is orthogonal to both the normal of the contact surface
     *     and the primary_direction.
     *     This trait is useful for modeling scenarios such as anisotropic surfaces or materials
     *     engineered to have specific directional friction properties.
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT OrientedFriction {
        public:
            OrientedFriction();
            virtual ~OrientedFriction();
            virtual std::shared_ptr<openplx::Math::Vec3> primary_direction() const = 0;
            virtual double secondary_coefficient() const = 0;
    };
}
