#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultDistanceFlexibility.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model LinearElasticDistanceFlexibility */
namespace openplx::Physics3D::Interactions::Flexibility {
    /**
     *     Define a linear elastic flexibility model for each constrained degree of freedom for a Distance mate.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT LinearElasticDistanceFlexibility : public openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility {
        protected:
            double m_default_stiffness;

        public:
            LinearElasticDistanceFlexibility();
            virtual ~LinearElasticDistanceFlexibility();
            double default_stiffness() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> along_distance() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
