#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Geometries/ContactGeometry.h>
#include <openplx/Math/AffineTransform.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ContactGeometry */
namespace openplx::Physics3D::Geometries {
    /**
     * Base model for 3d geometries that provoke collisions in the simulation.
     *
     * local_transform: The position and orientation relative to the parent system or body.
     *
     * enable_collisions: When set to false it will not provoke any collisions.
     *
     * include_in_mass_properties: When set to false the volume of the geometry will
     * not be accounted for in implicit mass property calculations.
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT ContactGeometry : public openplx::Physics::Geometries::ContactGeometry {
        protected:
            std::shared_ptr<openplx::Math::AffineTransform> m_local_transform;
            bool m_enable_collisions;
            bool m_include_in_mass_properties;

        public:
            ContactGeometry();
            virtual ~ContactGeometry();
            std::shared_ptr<openplx::Math::AffineTransform> local_transform() const;
            bool enable_collisions() const;
            bool include_in_mass_properties() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
