#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Geometries/ContactGeometry.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Capsule */
namespace openplx::Physics3D::Geometries {
    /** A capsule is a cylinder with rounded ends, the ends will be rounded
     * with the same radius as the cylinder.
     *
     * `height` is the height of the inner cylinder, the total height of the capsule will be: height + 2 * radius
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT Capsule : public openplx::Physics3D::Geometries::ContactGeometry {
        protected:
            double m_radius;
            double m_height;

        public:
            Capsule();
            virtual ~Capsule();
            double radius() const;
            double height() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
