#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics1D/Physics1DBundleExport.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Bodies/Body.h>
#include <openplx/Physics/Signals/AngleOutputTrait.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutputTrait.h>
#include <openplx/Physics1D/Bodies/RotationalKinematics.h>
#include <openplx/Physics/Signals/AngleOutput.h>
#include <openplx/Physics/Signals/AngularVelocity1DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RotationalBody */
namespace openplx::Physics1D::Bodies {
    class OPENPLX_Physics1D_BUNDLE_EXPORT RotationalBody : public openplx::Physics1D::Bodies::Body, public openplx::Physics::Signals::AngleOutputTrait, public openplx::Physics::Signals::AngularVelocity1DOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> m_angle_output;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> m_angular_velocity_output;

        public:
            RotationalBody();
            virtual ~RotationalBody();
            std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics> kinematics() const;
            std::shared_ptr<openplx::Physics::Signals::AngleOutput> angle_output() const;
            std::shared_ptr<openplx::Physics::Signals::AngularVelocity1DOutput> angular_velocity_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
