#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DryConeFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     Isotropic friction model for which the friction force depend on the current normal forces
     *     acting normal to the friction plane between two bodies.
     *     To compute the perfect cone while solving the non-linear normal/friction force equations
     *     is a very sophisticated approach that might be computationally very expensive when there are several interactions 
     *     and contacts present.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT DryConeFriction : public openplx::Physics::Interactions::Dissipation::DefaultDryFriction {
        protected:

        public:
            DryConeFriction();
            virtual ~DryConeFriction();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
