
#pragma once

#include <vector>
#include <memory>
#include <openplx/Token.h>
#include <openplx/NodeVisitor.h>

namespace openplx
{
    class OrTypeCommonParentBinder : private NodeVisitor
    {
        public:

            void bind(const DocPtr& document);

            static ModelDeclPtr findCommonParent(const std::vector<TypePtr>& types);

        private:
            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitVarAssignment(const VarAssignPtr &var_assignment) override;
    };
}
