
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/TreeNode.h>

namespace openplx {
    class FindEdgesVisitor : private NodeVisitor {
        public:
            FindEdgesVisitor();

            std::vector<OuterSymbolPtr> findReferenceEdges(const OuterSymbolPtr& target);

        private:
            void visitConstant(const ConstantPtr& constant) override;
            void visitCall(const CallPtr& call) override;
            void visitMemberAccess(const MemberAccessPtr& member_access) override;
            void visitArray(const ArrayPtr& array) override;
            void visitUnary(const UnaryPtr& unary) override;
            void visitBinaryOp(const BinaryOpPtr& binary_op) override;
            void visitIndexing(const IndexingPtr& indexing) override;
            void visitInitializer(const InitializerPtr& initializer) override;

            std::unordered_set<std::shared_ptr<OuterSymbol>> lookupValues(
                const std::shared_ptr<TreeNode<OuterSymbol>>& root,
                const std::vector<std::string>& path, size_t first_ix, size_t last_ix);

            NodePtr nsLookupMemberAccess(const MemberAccessPtr& member_access);

            std::shared_ptr<TreeNode<OuterSymbol>> m_outer_tree_root;
            std::vector<OuterSymbolPtr> m_results;
            DocPtr m_document;
            OuterSymbolPtr m_current;
    };
}
