#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/DriveTrain/Traits/RotationalPowerGenerator.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/RpmOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/FractionInput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model MeanValueEngine */
namespace openplx::DriveTrain {
    /**
     *     Combustion engine is one of the most widely used types of engines in various applications such as vehicles, excavators,
     *     wheelloaders, aircrafts and marine propulsion systems. It includes a number of components such as
     *     the cylinders, pistons, crankshaft, camshafts, valves, fuel injection system, ignition system,
     *     air intake and exhaust systems. The cylinders and the pistons form the main body of the engine,
     *     where the combustion process occurs. The combustion converts the chemical energy of the air-fuel
     *     mixture into the heat energy. The heat energy generates the high temperature as well as the
     *     high pressure inside the cylinders. The pressure pushes the pistons to move during the power stroke
     *     and outputs the torque to rotate the crank shaft. The crank shaft drives the gears in the drive train,
     *     which eventually enables the motion of the vehicle. The valves control the flow of air and
     *     fuel into and out of the engine cylinders, and the fuel injection and ignition systems manage the combustion process.
     *
     *     'displacement_volume'       - The total displacement volume of the engine, which is the sum of the volumes of the cylinders.
     *     'max_torque'                - The maximum rated torque which is the highest brake torque that an engine is allowed to deliver over short/continous periods of operations
     *     'max_torque_RPM'            - The rated torque speed (i.e. the crankshaft rotational speed) in which the maximum rated torque is delivered.
     *     'max_power_RPM'             - The rated power speed (i.e. the crankshaft rotational speed) in which the maximum rated power is delivered.
     *     'idle_RPM'                  - The crankshaft speed in which the engine is at idle condition.
     *     'max_RPM'                   - The maximum allowerable crankshaft speed of the engine.
     *     'crank_shaft_inertia'       - The moment of inertia of the crank shaft.
     *     'throttle_pin_bore_ratio'   - The ratio between throttle pin diameter and throttle bore diameter.
     *     'max_volumetric_efficiency' - Maximum volumetric efficiency of the engine. The volumetric efficiency refers to the ratio of air volume drawn into the cylinders to the volume the cylinder sweeps.
     *     'air_fuel_ratio'            - The stoichiometric air-fuel ratio. Ideal ratio of air to fuel needed for complete combustion, e.g. gasoline.
     *     'heat_value'                - The heat value of the fuel.
     *     'revolutions_per_cycle'     - The number of crankshaft revolutions during one engine operating cycle.
     *     'idle_throttle_angle'       - The smallest angle the throttle plate can have when the engine is running at idle.
     *     'max_throttle_angle'        - The maximum angle that the throttle plate is allowed to have.
     *     'inlet_volume'              - The inlet manifold volume of the engine.
     *     'initial_throttle'          - The initial_throttle is a value between 0-1, where 0 is no throttle, and 1 is max throttle.
     *
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT MeanValueEngine : public openplx::Physics::Interactions::Interaction1DOF, public openplx::DriveTrain::Traits::RotationalPowerGenerator, public openplx::Physics::Signals::FractionInputTrait, public openplx::Physics::Signals::RpmOutputTrait, public openplx::Physics::Signals::Torque1DOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::RpmOutput> m_rpm_output;
            double m_displacement_volume;
            double m_max_torque;
            double m_max_torque_RPM;
            double m_max_power_RPM;
            double m_idle_RPM;
            double m_max_RPM;
            double m_crank_shaft_inertia;
            double m_air_fuel_ratio;
            double m_heat_value;
            int64_t m_revolutions_per_cycle;
            double m_idle_throttle_angle;
            double m_max_throttle_angle;
            double m_inlet_volume;
            double m_throttle_pin_bore_ratio;
            double m_max_volumetric_efficiency;
            double m_initial_throttle;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_throttle_input;

        public:
            MeanValueEngine();
            virtual ~MeanValueEngine();
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const override;
            std::shared_ptr<openplx::Physics::Signals::RpmOutput> rpm_output() const override;
            double displacement_volume() const;
            double max_torque() const;
            double max_torque_RPM() const;
            double max_power_RPM() const;
            double idle_RPM() const;
            double max_RPM() const;
            double crank_shaft_inertia() const;
            double air_fuel_ratio() const;
            double heat_value() const;
            int64_t revolutions_per_cycle() const;
            double idle_throttle_angle() const;
            double max_throttle_angle() const;
            double inlet_volume() const;
            double throttle_pin_bore_ratio() const;
            double max_volumetric_efficiency() const;
            double initial_throttle() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> throttle_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
