#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/ManualClutch.h>
#include <openplx/Physics/Signals/DurationInputTrait.h>
#include <openplx/Physics/Signals/DurationOutputTrait.h>
#include <openplx/Physics/Signals/EngageInput.h>
#include <openplx/Physics/Signals/EngagedOutput.h>
#include <openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationInput.h>
#include <openplx/DriveTrain/Signals/AutomaticClutchEngagementDurationOutput.h>
#include <openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationInput.h>
#include <openplx/DriveTrain/Signals/AutomaticClutchDisengagementDurationOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AutomaticClutch */
namespace openplx::DriveTrain {
    /**
     * Extends the manual clutch with an automatic engage/disengage feature.
     * engagement_duration determine how long it takes to go from fully
     * open to fully engaged, while the disengagement_duration determine the time for disengagement.
     * The boolean ClutchEngageInput is used to engage and disengage the clutch.
     *
     * When using the automatic feature the engagement_fraction parameter is irrelevant.
     *
     * The automatic clutch is engaged by sending true on the engage_input, and disengaged by sending false.
     * initially_engaged will tell wether the clutch is engaged or not before any signal has been sent.
     **/
    class OPENPLX_DriveTrain_BUNDLE_EXPORT AutomaticClutch : public openplx::DriveTrain::ManualClutch, public openplx::Physics::Signals::DurationInputTrait, public openplx::Physics::Signals::DurationOutputTrait {
        protected:
            double m_engagement_duration;
            double m_disengagement_duration;
            bool m_initially_engaged;
            std::shared_ptr<openplx::Physics::Signals::EngageInput> m_engage_input;
            std::shared_ptr<openplx::Physics::Signals::EngagedOutput> m_engaged_output;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput> m_engagement_duration_input;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput> m_engagement_duration_output;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput> m_disengagement_duration_input;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput> m_disengagement_duration_output;

        public:
            AutomaticClutch();
            virtual ~AutomaticClutch();
            double engagement_duration() const;
            double disengagement_duration() const;
            bool initially_engaged() const;
            std::shared_ptr<openplx::Physics::Signals::EngageInput> engage_input() const;
            std::shared_ptr<openplx::Physics::Signals::EngagedOutput> engaged_output() const;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationInput> engagement_duration_input() const;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchEngagementDurationOutput> engagement_duration_output() const;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationInput> disengagement_duration_input() const;
            std::shared_ptr<openplx::DriveTrain::Signals::AutomaticClutchDisengagementDurationOutput> disengagement_duration_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
