#pragma once

#include <unordered_set>
#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>

namespace openplx {
    /**
     * Bind the trait implementation by creating virtual members from
     * the traits.
     */
    class BindTraitsVisitor : private NodeVisitor {
        public:
            BindTraitsVisitor(std::shared_ptr<ErrorReporter> error_reporter);
            void bind(const DocPtr& document);

        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitTraitImpl(const TraitImplPtr& trait_impl) override;

            // Recursively create virtual nodes
            void createVirtualNodes(const TraitImplPtr& trait_impl, std::unordered_set<ModelDeclPtr>& loop_detector);

            std::shared_ptr<ErrorReporter> m_error_reporter;
    };
}
