
#pragma once

#include <openplx/NodeVisitor.h>

namespace openplx {
    /**
     * Adds expression nodes as right hand side of declarations that has an
     * implicit right hand side. For now this is only variables declared with
     * the type of a const model. For example:
     *
     * const Foo:
     *     x is Real: 1.0
     *
     * Bar:
     *    foo1 is Foo: Foo
     *    foo2 is Foo
     *
     * foo2 has an implicit right hand side of "Foo" and is equivalent to
     * foo1.
     */
    class BindImplicitRhsVisitor : private NodeVisitor {
        public:
            BindImplicitRhsVisitor();
            void bind(const DocPtr& document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
    };
}
