
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class Array : public Expression, public std::enable_shared_from_this<Array>
    {
        public:
            /* Factories */
            static ArrayPtr create(const std::vector<ExprPtr>& elements, const Token& left_bracket, const Token& right_bracket);

            /* Overrides */
            ArrayPtr asArray() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Members */
            const std::vector<ExprPtr>& getElements() const;
            void appendToElements(ExprPtr member);

            /* Layout */
            void offsetLine(int64_t delta_line) override;

            col_t layoutOnSingleLine(line_t line, col_t column) override;

        private:
            Array();
            std::vector<ExprPtr> m_elements;
    };
}
