#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/AGX/AGXBundleExport.h>
#include <openplx/AGX/AGXForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Urdf/UrdfForward.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/Visuals/VisualsForward.h>
/* Generated code for model ContactReductionBinResolution */
namespace openplx::AGX {
    /**
     * A trait for specifying the resolution used when evaluating contacts for reduction between objects.
     * A high value will keep more contacts, lower will result in more aggressive reduction.
     * Commonly a value of 2 or 3 will give good result.
     * Values from 0 to 10 are valid, where a value of 0 means this will be overridden by the ContactReductionBinResolution from Space.
     **/
    class OPENPLX_AGX_BUNDLE_EXPORT ContactReductionBinResolution {
        public:
            ContactReductionBinResolution();
            virtual ~ContactReductionBinResolution();
            virtual int64_t bin_resolution() const = 0;
    };
}
